/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.Output;

public class ExceptionFilter
implements Filter {
    public static String MESSAGE_KEY = "message";
    public static String EXCEPTION_KEY = "exception";
    public static String STACK_TRACE_KEY = "stacktrace";
    public static String STACK_HEADER_KEY = "stackheader";
    public static String EXCEPTION = "exception";
    private boolean trace = true;

    public ExceptionFilter() {
    }

    public ExceptionFilter(boolean trace) {
        this.trace = trace;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        try {
            return chain.invoke();
        }
        catch (Throwable throwable) {
            return this.handleException(chain.getAction(), throwable);
        }
    }

    protected String handleException(Action a, Throwable throwable) {
        String message = ExceptionUtils.getRootCauseMessage((Throwable)throwable);
        Throwable t = ExceptionUtils.getRootCause((Throwable)throwable);
        String exp = t != null ? t.getClass().getName() : throwable.getClass().getName();
        Output output = a.getOutput();
        output.setValue(EXCEPTION_KEY, exp);
        output.setValue(MESSAGE_KEY, message);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        ExceptionUtils.printRootCauseStackTrace((Throwable)throwable, (PrintWriter)pw);
        String full_trace = sw.getBuffer().toString();
        String[] lines = full_trace.split("\\n");
        output.setValue(STACK_HEADER_KEY, lines[0]);
        output.setValue(STACK_TRACE_KEY, this.prepareStackTrace(lines));
        if (this.trace) {
            ExceptionUtils.printRootCauseStackTrace((Throwable)throwable);
        }
        return EXCEPTION;
    }

    protected String prepareStackTrace(String[] stacktrace) {
        StringBuffer sb = new StringBuffer(stacktrace.length * 75);
        for (int i = 0; i < stacktrace.length; ++i) {
            String s = stacktrace[i];
            if (i != 0) {
                sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            sb.append(this.prepareForHtml(s)).append("<br/>");
        }
        return sb.toString();
    }

    protected String prepareStackTrace(StackTraceElement[] stacktrace) {
        StringBuffer sb = new StringBuffer(stacktrace.length * 75);
        for (int i = 0; i < stacktrace.length; ++i) {
            String s = stacktrace[i].toString();
            if (i != 0) {
                sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            sb.append(this.prepareForHtml(s)).append("<br/>");
        }
        return sb.toString();
    }

    protected String prepareForHtml(String s) {
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        return s;
    }

    @Override
    public void destroy() {
    }
}

