/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.LinkedList;
import java.util.List;
import org.mentawai.core.Action;
import org.mentawai.core.BaseAction;
import org.mentawai.core.Filter;
import org.mentawai.core.InputWrapper;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.PojoAction;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.message.ClassMessageContext;
import org.mentawai.message.DefaultMessage;
import org.mentawai.message.FileMessageContext;
import org.mentawai.message.Message;
import org.mentawai.message.MessageContext;
import org.mentawai.message.MessageManager;

public class ErrorsFilter
extends InputWrapper
implements Filter {
    private final String name;
    private boolean alwaysReturnError = false;

    public ErrorsFilter(String name) {
        this.name = name;
    }

    public ErrorsFilter(String name, boolean alwaysReturnError) {
        this(name);
        this.alwaysReturnError = alwaysReturnError;
    }

    private MessageContext getMessageContext(Action action) {
        if (LocaleManager.isUseMasterForEverything()) {
            return new FileMessageContext(LocaleManager.getMaster(), "");
        }
        return new ClassMessageContext(action.getClass());
    }

    private List<Message> getErrors(Action action) {
        return MessageManager.getErrors(action, true);
    }

    private void addError(Action action, String error_id) {
        List<Message> errors = this.getErrors(action);
        errors.add(new DefaultMessage(error_id, this.getMessageContext(action), BaseAction.getMessageTokens(action, null)));
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        super.setInput(action.getInput());
        action.setInput(this);
        String result = chain.invoke();
        List errors = (List)super.getValue(this.name);
        if (errors == null) {
            return result;
        }
        for (String value : errors) {
            this.addError(action, value);
        }
        if (errors.size() > 0) {
            if (this.alwaysReturnError) {
                return "error";
            }
            Object actionResult = action.getOutput().getValue(PojoAction.RESULT);
            if (actionResult != null && !(actionResult instanceof String)) {
                return "error";
            }
        }
        return result;
    }

    @Override
    public Object getValue(String name) {
        if (name.equals(this.name)) {
            Object value = super.getValue(name);
            if (value != null) {
                return value;
            }
            LinkedList errors = new LinkedList();
            this.setValue(name, errors);
            return errors;
        }
        return super.getValue(name);
    }

    @Override
    public void destroy() {
    }
}

