/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import org.mentawai.core.Action;
import org.mentawai.core.BaseAction;
import org.mentawai.core.Filter;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.Output;
import org.mentawai.util.InjectionUtils;

public abstract class DynamicValueFilter
implements Filter {
    @Override
    public void destroy() {
    }

    protected abstract String getParamName();

    protected abstract String getValueName();

    protected String getBeanName() {
        return null;
    }

    protected String getBeanProperty() {
        if (this.getBeanName() == null) {
            return null;
        }
        return this.getParamName();
    }

    protected Object getValue(Object value) {
        return value;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        Input input = action.getInput();
        Output output = action.getOutput();
        Object val = input.getValue(this.getParamName());
        if (val != null) {
            output.setValue(this.getValueName(), this.getValue(val));
            return chain.invoke();
        }
        String res = chain.invoke();
        String beanName = this.getBeanName();
        boolean found = false;
        if (beanName == null) {
            Object obj = BaseAction.findValue(this.getParamName(), action);
            if (obj != null) {
                output.setValue(this.getValueName(), this.getValue(obj));
                found = true;
            }
        } else {
            String value;
            Object obj = BaseAction.findValue(beanName, action);
            if (obj != null && (value = InjectionUtils.getProperty(obj, this.getBeanProperty())) != null) {
                output.setValue(this.getValueName(), this.getValue(value));
                found = true;
            }
        }
        if (!found) {
            output.setValue(this.getValueName(), this.getValue(null));
        }
        return res;
    }
}

