/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.InvocationChain;
import org.mentawai.util.FindMethod;
import org.mentawai.util.InjectionUtils;

public class DependencyFilter
implements Filter {
    public static final int INPUT = 1;
    public static final int OUTPUT = 2;
    public static final int SESSION = 3;
    public static final int APPLICATION = 4;
    private Map<String, AccessibleObject> cache = Collections.synchronizedMap(new HashMap());
    private boolean tryField = true;
    private boolean throwException = false;
    private String source_key;
    private String target_key;
    private String attribute;
    private int source_scope = 1;
    private int target_scope = 1;

    public DependencyFilter(String source_key, String target_key) {
        this(source_key, target_key, source_key);
    }

    public DependencyFilter(String source_key, String target_key, String attribute) {
        this.source_key = source_key;
        this.target_key = target_key;
        this.attribute = attribute;
    }

    public DependencyFilter(String source_key, int source_scope, String target_key, String attribute) {
        this(source_key, target_key, attribute);
        this.source_scope = source_scope;
    }

    public DependencyFilter(String source_key, int source_scope, String target_key, int target_scope, String attribute) {
        this(source_key, source_scope, target_key, attribute);
        this.target_scope = target_scope;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("DependencyFilter: sourceKey=").append(this.source_key).append(" targetKey=").append(this.target_key);
        sb.append(" attribute=").append(this.attribute).append(" sourceScope=").append(this.getScope(this.source_scope));
        sb.append(" targetScope=").append(this.getScope(this.target_scope));
        return sb.toString();
    }

    private String getScope(int scope) {
        switch (scope) {
            case 1: {
                return "INPUT";
            }
            case 2: {
                return "OUTPUT";
            }
            case 3: {
                return "SESSION";
            }
            case 4: {
                return "APPLICATION";
            }
        }
        return "?";
    }

    public void setTryField(boolean tryField) {
        this.tryField = tryField;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action a = chain.getAction();
        Object target = null;
        switch (this.target_scope) {
            case 1: {
                target = a.getInput().getValue(this.target_key);
                break;
            }
            case 2: {
                target = a.getOutput().getValue(this.target_key);
                break;
            }
            case 3: {
                target = a.getSession().getAttribute(this.target_key);
                break;
            }
            case 4: {
                target = a.getApplication().getAttribute(this.target_key);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid target scope!");
            }
        }
        if (target == null) {
            if (this.throwException) {
                throw new FilterException("Cannot find target: " + this.target_key + " / " + this.target_scope);
            }
            return chain.invoke();
        }
        Object source = null;
        switch (this.source_scope) {
            case 1: {
                source = a.getInput().getValue(this.source_key);
                break;
            }
            case 2: {
                source = a.getOutput().getValue(this.source_key);
                break;
            }
            case 3: {
                source = a.getSession().getAttribute(this.source_key);
                break;
            }
            case 4: {
                source = a.getApplication().getAttribute(this.source_key);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid source scope!");
            }
        }
        if (source == null) {
            if (this.throwException) {
                throw new FilterException("Cannot find source: " + this.source_key + " / " + this.source_scope);
            }
            return chain.invoke();
        }
        boolean ok = this.setValue(target, this.attribute, source);
        if (this.throwException && !ok) {
            throw new FilterException("Cannot inject source in target: " + this.source_key + " / " + this.target_key + " / " + this.attribute);
        }
        return chain.invoke();
    }

    @Override
    public void destroy() {
    }

    private boolean setValue(Object bean, String name, Object value) {
        try {
            AccessibleObject obj;
            Field f;
            StringBuffer sb = new StringBuffer(30);
            sb.append("set");
            sb.append(name.substring(0, 1).toUpperCase());
            if (name.length() > 1) {
                sb.append(name.substring(1));
            }
            String methodName = sb.toString();
            if (!this.cache.containsKey(name)) {
                Method m;
                block15: {
                    m = null;
                    f = null;
                    try {
                        m = FindMethod.getMethod(bean.getClass(), methodName, new Class[]{value.getClass()});
                    }
                    catch (Exception e) {
                        Class primitive = InjectionUtils.getPrimitiveFrom(value);
                        if (primitive != null) {
                            try {
                                m = bean.getClass().getMethod(methodName, primitive);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (m != null || !this.tryField || (f = InjectionUtils.getField(bean, name)) == null) break block15;
                        f.setAccessible(true);
                    }
                }
                if (m != null) {
                    this.cache.put(name, m);
                    m.setAccessible(true);
                } else {
                    this.cache.put(name, f);
                }
            }
            if ((obj = this.cache.get(name)) == null) {
                return false;
            }
            if (obj instanceof Method) {
                Method m = (Method)obj;
                m.invoke(bean, value);
            } else if (obj instanceof Field) {
                f = (Field)obj;
                f.set(bean, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

