/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.mentawai.core.Filter;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.Output;

public class DateFilter
implements Filter {
    private final String dayField;
    private final String monthField;
    private final String yearField;
    private final String dateField;

    public DateFilter(String dayField, String monthField, String yearField, String dateField) {
        this.dayField = dayField;
        this.monthField = monthField;
        this.yearField = yearField;
        this.dateField = dateField;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Input input = chain.getAction().getInput();
        Locale loc = chain.getAction().getLocale();
        String lang = loc.getLanguage();
        String dd = input.getString(this.dayField);
        String mm = input.getString(this.monthField);
        String yyyy = input.getString(this.yearField);
        if (!(dd == null || mm == null || yyyy == null || dd.trim().equals("") || mm.trim().equals("") || yyyy.trim().equals(""))) {
            if (lang.equals("pt")) {
                input.setValue(this.dateField, dd + "/" + mm + "/" + yyyy);
            } else {
                input.setValue(this.dateField, mm + "/" + dd + "/" + yyyy);
            }
        }
        String res = chain.invoke();
        Output output = chain.getAction().getOutput();
        Object obj = output.getValue(this.dateField);
        if (obj instanceof Date) {
            Date d = (Date)obj;
            Calendar c = GregorianCalendar.getInstance();
            c.setTime(d);
            this.prepareOutput(output, c);
        } else if (obj instanceof Calendar) {
            Calendar c = (Calendar)obj;
            this.prepareOutput(output, c);
        }
        return res;
    }

    private void prepareOutput(Output output, Calendar c) {
        output.setValue(this.dayField, c.get(5));
        output.setValue(this.monthField, c.get(2) + 1);
        output.setValue(this.yearField, c.get(1));
    }

    @Override
    public void destroy() {
    }
}

