/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import org.mentawai.core.Action;
import org.mentawai.core.Context;
import org.mentawai.core.Filter;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;

public class CookieFilter
implements Filter {
    private final String name;
    private final String cookieName;

    public CookieFilter(String name) {
        this(name, name);
    }

    public CookieFilter(String name, String cookieName) {
        this.name = name;
        this.cookieName = cookieName;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        Input input = action.getInput();
        Context cookies = action.getCookies();
        if (cookies != null && cookies.hasAttribute(this.cookieName)) {
            input.setValue(this.name, cookies.getAttribute(this.cookieName));
        }
        return chain.invoke();
    }

    @Override
    public void destroy() {
    }
}

