/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.HashMap;
import org.mentawai.converter.ConversionException;
import org.mentawai.converter.Convertable;
import org.mentawai.converter.Converter;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;

public class ConverterFilter
implements Filter {
    private boolean restore = true;

    public ConverterFilter() {
    }

    public ConverterFilter(boolean restore) {
        this.restore = restore;
    }

    public void setRestore(boolean restore) {
        this.restore = restore;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Object actionImpl;
        Action action = chain.getAction();
        Object pojo = chain.getPojo();
        Object object = actionImpl = pojo != null ? pojo : action;
        if (!(actionImpl instanceof Convertable)) {
            return chain.invoke();
        }
        Input input = action.getInput();
        HashMap<String, Object> initialValues = null;
        if (this.restore) {
            initialValues = new HashMap<String, Object>();
        }
        HashMap<String, Converter> converters = new HashMap<String, Converter>();
        Convertable convertable = (Convertable)actionImpl;
        convertable.prepareConverters(converters, chain.getInnerAction());
        try {
            for (String field : converters.keySet()) {
                Converter c = (Converter)converters.get(field);
                Object oldValue = input.getValue(field);
                Object converted = c.convert(field, action);
                input.setValue(field, converted);
                if (!this.restore) continue;
                initialValues.put(field, oldValue);
            }
        }
        catch (ConversionException e) {
            e.printStackTrace();
            throw new FilterException(e);
        }
        try {
            String e = chain.invoke();
            return e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.restore) {
                for (String field : initialValues.keySet()) {
                    Object value = initialValues.get(field);
                    input.setValue(field, value);
                }
            }
        }
    }

    @Override
    public void destroy() {
    }
}

