/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.HashMap;
import java.util.Map;
import org.mentawai.converter.ConversionException;
import org.mentawai.converter.Converter;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;

public abstract class ConversionFilter
implements Filter {
    private boolean restore = true;

    public ConversionFilter() {
    }

    public ConversionFilter(boolean restore) {
        this.restore = restore;
    }

    public void setRestore(boolean restore) {
        this.restore = restore;
    }

    public abstract void prepareConverters(Map<String, Converter> var1, Action var2, String var3);

    private Map<String, Converter> getConverters(Action action, String innerAction) {
        HashMap<String, Converter> converters = new HashMap<String, Converter>();
        this.prepareConverters(converters, action, innerAction);
        return converters;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        Input input = action.getInput();
        HashMap<String, Object> initialValues = null;
        if (this.restore) {
            initialValues = new HashMap<String, Object>();
        }
        Map<String, Converter> converters = this.getConverters(action, chain.getInnerAction());
        try {
            for (String field : converters.keySet()) {
                Converter c = converters.get(field);
                Object oldValue = input.getValue(field);
                Object converted = c.convert(field, action);
                input.setValue(field, converted);
                if (!this.restore) continue;
                initialValues.put(field, oldValue);
            }
        }
        catch (ConversionException e) {
            e.printStackTrace();
            throw new FilterException(e);
        }
        try {
            String e = chain.invoke();
            return e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.restore) {
                for (String field : initialValues.keySet()) {
                    Object value = initialValues.get(field);
                    input.setValue(field, value);
                }
            }
        }
    }

    @Override
    public void destroy() {
    }
}

