/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.sql.Connection;
import java.sql.SQLException;
import org.mentacontainer.Container;
import org.mentawai.core.Action;
import org.mentawai.core.AfterConsequenceFilter;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Consequence;
import org.mentawai.core.InputWrapper;
import org.mentawai.core.InvocationChain;
import org.mentawai.db.ConnectionHandler;

public class ConnectionFilter
extends InputWrapper
implements AfterConsequenceFilter {
    public static final String KEY = "conn";
    private final ConnectionHandler connHandler;
    private String connKey;
    private ThreadLocal<Connection> conn = new ThreadLocal();

    public ConnectionFilter(String connKey, ConnectionHandler connHandler) {
        this.connKey = connKey;
        this.connHandler = connHandler;
    }

    public ConnectionFilter(ConnectionHandler connHandler) {
        this(KEY, connHandler);
    }

    public ConnectionFilter(ConnectionHandler connHandler, String connKey) {
        this(connKey, connHandler);
    }

    public void setKey(String key) {
        this.connKey = key;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        super.setInput(action.getInput());
        action.setInput(this);
        return chain.invoke();
    }

    @Override
    public void afterConsequence(Action action, Consequence c, boolean conseqExecuted, boolean actionExecuted, String result) {
        Connection conn = this.conn.get();
        if (conn != null) {
            this.conn.set(null);
            this.removeValue(this.connKey);
            this.connHandler.release(conn);
        } else {
            Container container = ApplicationManager.getContainer();
            if (container != null && (conn = (Connection)container.clear(this.connKey)) != null) {
                this.connHandler.release(conn);
            }
        }
    }

    @Override
    public Object getValue(String key) {
        if (key.equals(this.connKey)) {
            Connection c = this.conn.get();
            if (c == null) {
                try {
                    c = (Connection)super.getValue(this.connKey);
                    if (c == null) {
                        c = this.connHandler.getConnection();
                    }
                    this.conn.set(c);
                    this.setValue(this.connKey, c);
                }
                catch (SQLException e) {
                    throw new RuntimeException("Error while getting the connection from de connection handler '" + this.connHandler + "': " + e, e);
                }
            }
            return c;
        }
        return super.getValue(key);
    }

    @Override
    public void destroy() {
        this.connHandler.destroy();
    }
}

