/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.FilterException;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;

public class CollectionFilter
implements Filter {
    private int maxAllowed = 128;
    private final String attrName;

    public CollectionFilter(String attrName) {
        this.attrName = attrName;
    }

    public CollectionFilter(String attrName, int maxAllowed) {
        this(attrName);
        this.maxAllowed = maxAllowed;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        Input input = action.getInput();
        Iterator<String> iter = input.keys();
        Object[] list = new Object[this.maxAllowed];
        int len = this.attrName.length();
        int max = 0;
        while (iter.hasNext()) {
            int index;
            String key = iter.next();
            if (!key.startsWith(this.attrName) || key.length() <= len) continue;
            try {
                index = this.parseNumberFromKey(this.attrName, key);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (index >= this.maxAllowed) {
                throw new FilterException("Number too big: " + index + " (max = " + max + ")");
            }
            if (index > max) {
                max = index;
            }
            list[index] = input.getValue(key);
        }
        Collection<Object> coll = this.buildCollection(list, max);
        input.setValue(this.attrName, coll);
        return chain.invoke();
    }

    protected Collection<Object> buildCollection(Object[] list, int max) {
        ArrayList<Object> coll = new ArrayList<Object>(max);
        for (int i = 0; i < max; ++i) {
            coll.add(list[i]);
        }
        return coll;
    }

    protected int parseNumberFromKey(String attrName, String key) throws NumberFormatException {
        int len = attrName.length();
        String number = key.substring(len);
        return Integer.parseInt(number);
    }

    @Override
    public void destroy() {
    }
}

