/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.mentawai.core.Action;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Filter;
import org.mentawai.core.InputWrapper;
import org.mentawai.core.InvocationChain;
import org.mentawai.log.Debug;
import org.mentawai.util.InjectionUtils;
import org.mentawai.util.RuntimeException;

public class AutoWiringFilter
extends InputWrapper
implements Filter {
    private static final String NAME = "AutoWiringFilter";
    private Map<String, AccessibleObject> cache = new HashMap<String, AccessibleObject>();
    private Map<Object, Object> received = new WeakHashMap<Object, Object>();
    private boolean tryField = true;
    private final String sourceKey;
    private final String attrName;
    private final Class<? extends Object> sourceClass = null;
    private boolean newVersion = true;

    public AutoWiringFilter(boolean tryField) {
        this.sourceKey = null;
        this.attrName = null;
        this.tryField = tryField;
    }

    public AutoWiringFilter() {
        this(true);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        if (this.newVersion) {
            sb.append("AutoWiringFilter: tryField=").append(this.tryField);
        } else {
            sb.append("AutoWiringFilter (deprecated): sourceKey=").append(this.sourceKey).append(" attrName=").append(this.attrName).append(" sourceClass=").append(this.sourceClass.getName());
            sb.append(" tryField=").append(this.tryField);
        }
        return sb.toString();
    }

    public void setTryField(boolean tryField) {
        this.tryField = tryField;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action a = chain.getAction();
        this.setInput(a.getInput());
        a.setInput(this);
        return chain.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMethodOrField(Class<? extends Object> target) {
        String className = target.getName();
        AccessibleObject obj = null;
        Map<String, AccessibleObject> map = this.cache;
        synchronized (map) {
            obj = this.cache.get(className);
        }
        if (obj != null) {
            return obj;
        }
        Method m = InjectionUtils.findMethodToInject(target, this.attrName, this.sourceClass);
        if (Debug.isEnabled()) {
            Debug.log(NAME, "Finding method:", "target=", target.getName(), "attrName=", this.attrName, "sourceClass=", this.sourceClass.getName(), "methodFound=", m == null ? "NULL" : m.getName());
        }
        if (m != null) {
            Map<String, AccessibleObject> map2 = this.cache;
            synchronized (map2) {
                this.cache.put(className, m);
            }
            return m;
        }
        if (this.tryField) {
            Field f = InjectionUtils.findFieldToInject(target, this.attrName, this.sourceClass);
            if (Debug.isEnabled()) {
                Debug.log(NAME, "Finding field:", "target=", target.getName(), "attrName=", this.attrName, "sourceClass=", this.sourceClass.getName(), "methodFound=", f == null ? "NULL" : f.getName());
            }
            if (f != null) {
                Map<String, AccessibleObject> map3 = this.cache;
                synchronized (map3) {
                    this.cache.put(className, f);
                }
                return f;
            }
        }
        Map<String, AccessibleObject> map4 = this.cache;
        synchronized (map4) {
            this.cache.put(className, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAlreadyReceived(Object target) {
        Map<Object, Object> map = this.received;
        synchronized (map) {
            return this.received.containsKey(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAlreadyReceived(Object target) {
        Map<Object, Object> map = this.received;
        synchronized (map) {
            this.received.put(target, null);
        }
    }

    @Override
    public void setValue(String key, Object value) {
        super.setValue(key, value);
        this.getValue(key);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object getValue(String key) {
        if (!this.newVersion) {
            return this.getValueOld(key);
        }
        target = super.getValue(key);
        if (target != null) {
            iter = ApplicationManager.getInstance().getDependencies();
            while (iter.hasNext()) {
                d = iter.next();
                obj = d.getMethodOrField(target.getClass(), this.tryField);
                if (Debug.isEnabled()) {
                    Debug.log(new Object[]{"AutoWiringFilter", "Has dependency?", "target =", target.getClass().getName(), "key =", key, "depFound =", obj});
                }
                if (obj != null) {
                    hasAlreadyReceived = d.hasAlreadyReceived(target);
                    if (Debug.isEnabled()) {
                        Debug.log(new Object[]{"AutoWiringFilter", "HasAlreadyReceived?", "target =", target, "hasAlreadyReceived =", hasAlreadyReceived});
                    }
                    if (!hasAlreadyReceived) {
                        sourceKey = d.getSource();
                        if (sourceKey.equals(key)) continue;
                        source = this.getValue(sourceKey);
                        v0 = isAssignable = source != null && d.getDependencyClass().isAssignableFrom(source.getClass()) != false;
                        if (Debug.isEnabled()) {
                            Debug.log(new Object[]{"AutoWiringFilter", "isAssignable?", "source =", source == null ? "NULL" : source.getClass().getName(), "isAssignable =", isAssignable, "sourceKey =", sourceKey == null ? "NULL" : sourceKey});
                        }
                        if (isAssignable) {
                            if (obj instanceof Method) {
                                m = (Method)obj;
                                try {
                                    if (Debug.isEnabled()) {
                                        Debug.log(new Object[]{"AutoWiringFilter", "Injecting thru method!", "method =", m.getName(), "target =", target, "source =", source});
                                    }
                                    m.invoke(target, new Object[]{source});
                                    d.setAlreadyReceived(target);
                                    if (!Debug.isEnabled()) ** GOTO lbl52
                                    Debug.log(new String[]{"AutoWiringFilter", "Injecting thru method succeeded!"});
                                }
                                catch (Exception e) {
                                    if (Debug.isEnabled()) {
                                        Debug.log(new String[]{"AutoWiringFilter", "Injecting thru method failed!", "exception =", e.getMessage()});
                                    }
                                    throw new RuntimeException("AutoWiringFilter cannot inject dependency: method = " + (m != null ? m.getName() : "NULL") + " / source = " + (source != null ? source : "NULL") + " / target = " + target, e, true);
                                }
                            } else if (obj instanceof Field) {
                                f = (Field)obj;
                                try {
                                    if (Debug.isEnabled()) {
                                        Debug.log(new Object[]{"AutoWiringFilter", "Injecting thru field!", "field =", f.getName(), "target =", target, "source =", source});
                                    }
                                    f.set(target, source);
                                    d.setAlreadyReceived(target);
                                    if (Debug.isEnabled()) {
                                        Debug.log(new String[]{"AutoWiringFilter", "Injecting thru field succeeded!"});
                                    }
                                }
                                catch (Exception e) {
                                    if (Debug.isEnabled()) {
                                        Debug.log(new String[]{"AutoWiringFilter", "Injecting thru field failed!", "exception =", e.getMessage()});
                                    }
                                    throw new RuntimeException("AutoWiringFilter cannot inject dependency: field = " + (f != null ? f.getName() : "NULL") + " / source = " + (source != null ? source : "NULL") + " / target = " + target, e, true);
                                }
                            }
                        }
                    }
                }
lbl52:
                // 11 sources

                if (!Debug.isEnabled()) continue;
                Debug.log(new String[]{""});
            }
        }
        return target;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValueOld(String key) {
        boolean isAssignable;
        Object target = super.getValue(key);
        if (target == null) return target;
        Object obj = this.getMethodOrField(target.getClass());
        if (Debug.isEnabled()) {
            Debug.log(NAME, "Has dependency?", "target =", target.getClass().getName(), "key =", key, "depFound =", obj);
        }
        if (obj == null) return target;
        boolean hasAlreadyReceived = this.hasAlreadyReceived(target);
        if (Debug.isEnabled()) {
            Debug.log(NAME, "HasAlreadyReceived?", "target =", target.getClass().getName(), "hasAlreadyReceived =", hasAlreadyReceived);
        }
        if (hasAlreadyReceived) return target;
        Object source = super.getValue(this.sourceKey);
        boolean bl = isAssignable = source != null && this.sourceClass.isAssignableFrom(source.getClass());
        if (Debug.isEnabled()) {
            Debug.log(NAME, "isAssignable?", "source =", source == null ? "NULL" : source.getClass().getName(), "isAssignable =", isAssignable, "sourceKey =", this.sourceKey);
        }
        if (!isAssignable) return target;
        if (obj instanceof Method) {
            Method m = (Method)obj;
            try {
                if (Debug.isEnabled()) {
                    Debug.log(NAME, "Injecting thru method!", "method =", m.getName(), "target =", target.getClass().getName(), "source =", source);
                }
                m.invoke(target, source);
                this.setAlreadyReceived(target);
                if (!Debug.isEnabled()) return target;
                Debug.log(NAME, "Injecting thru method succeeded!");
                return target;
            }
            catch (Exception e) {
                if (!Debug.isEnabled()) throw new RuntimeException("AutoWiringFilter cannot inject dependency: method = " + (m != null ? m.getName() : "NULL") + " / source = " + (source != null ? source : "NULL") + " / target = " + target, e, true);
                Debug.log(NAME, "Injecting thru method failed!", "exception =", e.getMessage());
                throw new RuntimeException("AutoWiringFilter cannot inject dependency: method = " + (m != null ? m.getName() : "NULL") + " / source = " + (source != null ? source : "NULL") + " / target = " + target, e, true);
            }
        }
        if (!(obj instanceof Field)) return target;
        Field f = (Field)obj;
        try {
            if (Debug.isEnabled()) {
                Debug.log(NAME, "Injecting thru field!", "field =", f.getName(), "target =", target.getClass().getName(), "source =", source);
            }
            f.set(target, source);
            this.setAlreadyReceived(target);
            if (!Debug.isEnabled()) return target;
            Debug.log(NAME, "Injecting thru field succeeded!");
            return target;
        }
        catch (Exception e) {
            if (!Debug.isEnabled()) throw new RuntimeException("AutoWiringFilter cannot inject dependency: field = " + (f != null ? f.getName() : "NULL") + " / source = " + (source != null ? source : "NULL") + " / target = " + target, e, true);
            Debug.log(NAME, "Injecting thru field failed!", "exception =", e.getMessage());
            throw new RuntimeException("AutoWiringFilter cannot inject dependency: field = " + (f != null ? f.getName() : "NULL") + " / source = " + (source != null ? source : "NULL") + " / target = " + target, e, true);
        }
    }

    @Override
    public void destroy() {
    }
}

