/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mentawai.action.BaseLoginAction;
import org.mentawai.ajax.AjaxAction;
import org.mentawai.authorization.Authorizable;
import org.mentawai.authorization.AuthorizationManager;
import org.mentawai.authorization.Group;
import org.mentawai.authorization.Permission;
import org.mentawai.core.Action;
import org.mentawai.core.Context;
import org.mentawai.core.Filter;
import org.mentawai.core.InvocationChain;

public class AuthorizationFilter
implements Filter {
    public static final String ACCESSDENIED = "accessdenied";
    public static final String AJAX_DENIED = "ajax_denied";
    private List<String> groups = null;
    private List<String> permissions = null;
    private List<Group> listGroups;

    public AuthorizationFilter() {
    }

    public AuthorizationFilter(Enum<?> ... es) {
        this(AuthorizationFilter.toString(es));
    }

    private static String[] toString(Enum<?> ... es) {
        String[] s = new String[es.length];
        int index = 0;
        for (Enum<?> e : es) {
            s[index++] = e.toString();
        }
        return s;
    }

    public AuthorizationFilter(String ... groups) {
        String[] s;
        this.groups = new ArrayList<String>(groups.length);
        if (groups.length == 1 && (s = groups[0].split("\\s*\\,\\s*")).length > 1) {
            for (int i = 0; i < s.length; ++i) {
                this.groups.add(s[i]);
            }
            return;
        }
        for (int i = 0; i < groups.length; ++i) {
            this.groups.add(groups[i]);
        }
    }

    public AuthorizationFilter(List<Object> groups) {
        this.groups = new ArrayList<String>(groups.size());
        for (Object obj : groups) {
            if (obj instanceof Group) {
                Group g = (Group)obj;
                this.groups.add(g.getName());
                continue;
            }
            if (obj instanceof String) {
                String s = (String)obj;
                this.groups.add(s);
                continue;
            }
            if (!(obj instanceof Permission)) continue;
            if (this.permissions == null) {
                this.permissions = new LinkedList<String>();
            }
            Permission p = (Permission)obj;
            this.permissions.add(p.getName());
        }
    }

    public AuthorizationFilter(Permission ... permissions) {
        this.permissions = new ArrayList<String>(permissions.length);
        for (int i = 0; i < permissions.length; ++i) {
            this.permissions.add(permissions[i].getName());
        }
    }

    public AuthorizationFilter(String groups, Permission permission) {
        this(groups);
        this.permissions = new ArrayList<String>(1);
        this.permissions.add(permission.getName());
    }

    public AuthorizationFilter(List<Object> groups, Permission permission) {
        this(groups);
        this.permissions = new ArrayList<String>(1);
        this.permissions.add(permission.getName());
    }

    public AuthorizationFilter(List<Object> groups, Permission ... permissions) {
        this(groups);
        this.permissions = new ArrayList<String>(permissions.length);
        for (int i = 0; i < permissions.length; ++i) {
            this.permissions.add(permissions[i].getName());
        }
    }

    public boolean isAuthorized(Action action, String actionName, String innerAction, Object user, List userGroups) {
        return true;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        Object pojo = chain.getPojo();
        Object actionImpl = pojo != null ? pojo : action;
        Context session = action.getSession();
        List<Object> usergroups = BaseLoginAction.getUserGroups(session);
        Object user = BaseLoginAction.getUserSession(session);
        boolean ok = false;
        if (this.groups == null && this.permissions == null) {
            if (actionImpl instanceof Authorizable) {
                Authorizable authorizable = (Authorizable)actionImpl;
                ok = authorizable.authorize(chain.getInnerAction(), user, usergroups);
            } else {
                ok = this.isAuthorized(action, chain.getActionName(), chain.getInnerAction(), user, usergroups);
            }
        } else {
            if (usergroups == null || usergroups.size() == 0) {
                if (actionImpl instanceof AjaxAction) {
                    return AJAX_DENIED;
                }
                return ACCESSDENIED;
            }
            if (this.groups != null && this.groups.size() > 0) {
                for (int i = 0; i < this.groups.size(); ++i) {
                    for (int j = 0; j < usergroups.size(); ++j) {
                        String group = this.groups.get(i).toString();
                        Object objGroup = usergroups.get(j);
                        String usergroup = null;
                        if (objGroup instanceof String) {
                            usergroup = objGroup.toString();
                        } else if (objGroup instanceof Group) {
                            usergroup = ((Group)objGroup).getName();
                        }
                        if (group.startsWith("!")) {
                            if (usergroup.equalsIgnoreCase(group.substring(1))) {
                                ok = false;
                                continue;
                            }
                            ok = true;
                            i = this.groups.size();
                            j = usergroups.size();
                            continue;
                        }
                        if (!usergroup.equalsIgnoreCase(group)) continue;
                        ok = true;
                        i = this.groups.size();
                        j = usergroups.size();
                    }
                }
                if (!ok) {
                    if (actionImpl instanceof AjaxAction) {
                        return AJAX_DENIED;
                    }
                    return ACCESSDENIED;
                }
            }
            if (this.permissions != null && this.permissions.size() > 0) {
                Iterator<Object> iter = usergroups.iterator();
                String usergroup = null;
                block2: while (iter.hasNext()) {
                    Object objGroup = iter.next();
                    if (objGroup instanceof List) {
                        this.listGroups = (List)objGroup;
                        block3: for (int k = 0; k < this.listGroups.size(); ++k) {
                            Group ggg = (Group)objGroup;
                            for (int a = 0; a < this.permissions.size(); ++a) {
                                String ppp = this.permissions.get(a).substring(1);
                                if (!AuthorizationManager.check(ggg, ppp)) continue;
                                ok = true;
                                continue block3;
                            }
                        }
                        continue;
                    }
                    if (objGroup instanceof String) {
                        usergroup = objGroup.toString();
                        for (int a = 0; a < this.permissions.size(); ++a) {
                            String ppp = this.permissions.get(a);
                            if (!AuthorizationManager.check(usergroup, ppp)) continue;
                            ok = true;
                            continue block2;
                        }
                        continue;
                    }
                    if (!(objGroup instanceof Group)) continue;
                    Group ggg = (Group)objGroup;
                    for (int a = 0; a < this.permissions.size(); ++a) {
                        String ppp = this.permissions.get(a);
                        if (!AuthorizationManager.check(ggg, ppp)) continue;
                        ok = true;
                        continue block2;
                    }
                }
                if (!ok) {
                    if (actionImpl instanceof AjaxAction) {
                        return AJAX_DENIED;
                    }
                    return ACCESSDENIED;
                }
            }
        }
        if (!ok) {
            if (actionImpl instanceof AjaxAction) {
                return AJAX_DENIED;
            }
            return ACCESSDENIED;
        }
        return chain.invoke();
    }

    @Override
    public void destroy() {
    }
}

