/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mentawai.action.BaseLoginAction;
import org.mentawai.ajax.AjaxAction;
import org.mentawai.core.Action;
import org.mentawai.core.ActionConfig;
import org.mentawai.core.Context;
import org.mentawai.core.Filter;
import org.mentawai.core.Input;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.SessionContext;
import org.mentawai.filter.AuthenticationFree;
import org.mentawai.filter.AuthenticationFreeMarkerFilter;
import org.mentawai.filter.RedirectAfterLogin;
import org.mentawai.filter.RedirectAfterLoginMarkerFilter;
import org.mentawai.jruby.JRubyInterpreter;
import org.mentawai.jruby.RubyAction;

public class AuthenticationFilter
implements Filter {
    public static final String LOGIN = "login";
    public static final String AJAX_DENIED = "ajax_denied";
    public static final String URL_KEY = "url";

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Filter f;
        Action action = chain.getAction();
        Object pojo = chain.getPojo();
        Object actionImpl = pojo != null ? pojo : action;
        String innerAction = chain.getInnerAction();
        Context session = action.getSession();
        ActionConfig ac = chain.getActionConfig();
        if (ac.isInternalOnly()) {
            return chain.invoke();
        }
        boolean shouldBypass = false;
        if (actionImpl instanceof AuthenticationFree) {
            AuthenticationFree af = (AuthenticationFree)actionImpl;
            shouldBypass = af.bypassAuthentication(innerAction);
        } else if (action instanceof RubyAction) {
            RubyAction ra = (RubyAction)action;
            JRubyInterpreter ruby = JRubyInterpreter.getInstance();
            if (ruby.respondTo(ra.getRubyObject(), "bypassAuthentication")) {
                shouldBypass = (Boolean)ruby.call(ra.getRubyObject(), "bypassAuthentication", Boolean.class, innerAction);
            }
        }
        if (!shouldBypass && (f = chain.getFilter(AuthenticationFreeMarkerFilter.class)) != null) {
            AuthenticationFreeMarkerFilter aff = (AuthenticationFreeMarkerFilter)f;
            shouldBypass = aff.bypassAuthentication(innerAction);
        }
        if (!shouldBypass && !BaseLoginAction.isLogged(session)) {
            Input input;
            String value;
            Filter f2;
            boolean shouldRedirect = false;
            if (actionImpl instanceof RedirectAfterLogin) {
                RedirectAfterLogin ral = (RedirectAfterLogin)actionImpl;
                shouldRedirect = ral.shouldRedirect(innerAction);
            } else if (action instanceof RubyAction) {
                RubyAction ra = (RubyAction)action;
                JRubyInterpreter ruby = JRubyInterpreter.getInstance();
                if (ruby.respondTo(ra.getRubyObject(), "shouldRedirect")) {
                    shouldRedirect = (Boolean)ruby.call(ra.getRubyObject(), "shouldRedirect", Boolean.class, innerAction);
                }
            }
            if (!shouldRedirect && (f2 = chain.getFilter(RedirectAfterLoginMarkerFilter.class)) != null) {
                RedirectAfterLoginMarkerFilter ramf = (RedirectAfterLoginMarkerFilter)f2;
                shouldRedirect = ramf.shouldRedirect(innerAction);
            }
            if (shouldRedirect) {
                HttpServletRequest req = ((SessionContext)session).getRequest();
                HttpSession ses = ((SessionContext)session).getSession();
                AuthenticationFilter.setCallbackUrl(ses, req);
            }
            if (actionImpl instanceof AjaxAction) {
                return AJAX_DENIED;
            }
            if (actionImpl instanceof Action && "true".equals(value = (input = ((Action)actionImpl).getInput()).getHeader("isAjaxRequest"))) {
                return AJAX_DENIED;
            }
            return LOGIN;
        }
        return chain.invoke();
    }

    public static void setCallbackUrl(HttpSession session, HttpServletRequest req) {
        StringBuffer url = req.getRequestURL();
        String query = req.getQueryString();
        if (query != null) {
            url.append('?');
            url.append(query);
        }
        session.setAttribute(URL_KEY, (Object)url.toString());
    }

    @Override
    public void destroy() {
    }
}

