/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import org.mentawai.core.Action;
import org.mentawai.core.Context;
import org.mentawai.core.Filter;
import org.mentawai.core.InputWrapper;
import org.mentawai.core.InvocationChain;

public class ApplicationFilter
extends InputWrapper
implements Filter {
    private final String name;
    private ThreadLocal<Action> action = new ThreadLocal();

    public ApplicationFilter(String name) {
        this.name = name;
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        super.setInput(action.getInput());
        action.setInput(this);
        this.action.set(action);
        return chain.invoke();
    }

    @Override
    public Object getValue(String name) {
        if (name.equals(this.name)) {
            Object value = super.getValue(name);
            if (value != null) {
                return value;
            }
            Action action = this.action.get();
            if (action == null) {
                throw new IllegalStateException("Action cannot be null here!");
            }
            Context application = action.getApplication();
            this.setValue(name, application);
            return application;
        }
        return super.getValue(name);
    }

    @Override
    public void destroy() {
    }
}

