/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.filter;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.mentawai.ajax.AjaxConsequence;
import org.mentawai.core.Action;
import org.mentawai.core.Filter;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.Output;
import org.mentawai.message.Message;
import org.mentawai.message.MessageManager;

public class AjaxValidationFilter
implements Filter {
    @Override
    public void destroy() {
    }

    @Override
    public String filter(InvocationChain chain) throws Exception {
        Action action = chain.getAction();
        Locale loc = action.getLocale();
        String result = chain.invoke();
        Output output = action.getOutput();
        if (result.equals("error")) {
            Map<String, Message> fieldErrors = MessageManager.getFieldErrors(action, true);
            if (!fieldErrors.isEmpty()) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                Map.Entry<String, Message> entry2 = null;
                for (Map.Entry<String, Message> entry2 : fieldErrors.entrySet()) {
                    Message msg = fieldErrors.get(entry2.getKey());
                    map.put(entry2.getKey().toString(), msg.getText(loc));
                }
                output.setValue(AjaxConsequence.OBJECT, map);
            } else {
                List<Message> errors = MessageManager.getErrors(action, true);
                if (!errors.isEmpty()) {
                    output.setValue(AjaxConsequence.OBJECT, this.proccessList(errors, loc));
                } else if (output.getValue(AjaxConsequence.OBJECT) == null) {
                    output.setValue(AjaxConsequence.OBJECT, new HashMap());
                }
            }
        } else {
            List<Message> messages = MessageManager.getMessages(action, true);
            if (!messages.isEmpty()) {
                output.setValue(AjaxConsequence.OBJECT, this.proccessList(messages, loc));
            } else if (output.getValue(AjaxConsequence.OBJECT) == null) {
                output.setValue(AjaxConsequence.OBJECT, new HashMap());
            }
        }
        return result;
    }

    protected Map<String, String> proccessList(List<Message> list, Locale loc) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int msgNumber = 0;
        for (Message message : list) {
            map.put("msg" + ++msgNumber, message.getText(loc));
        }
        return map;
    }
}

