/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.db;

import java.sql.Connection;
import org.mentacontainer.Container;
import org.mentacontainer.Scope;
import org.mentawai.core.Action;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.BaseAction;
import org.mentawai.db.JdbcTemplate;
import org.mentawai.transaction.JdbcTransaction;
import org.mentawai.transaction.Transaction;

public class JdbcContext {
    public static String CONN_KEY = "conn";
    public static String TRANSACTION_KEY = "transaction";

    public static <T> Object exec(Class<T> klass, JdbcTemplate<T> template) {
        Container c = ApplicationManager.getContainer();
        if (c == null) {
            throw new RuntimeException("Cannot find container in application manager!");
        }
        return JdbcContext.exec(c, klass, template);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> Object exec(Container container, Class<T> klass, JdbcTemplate<T> template) {
        Connection conn = null;
        Transaction t = null;
        boolean wasConnAlreadyPresent = false;
        try {
            T action;
            if (container.check(CONN_KEY)) {
                conn = (Connection)container.get(CONN_KEY);
                wasConnAlreadyPresent = true;
            } else {
                conn = (Connection)container.get(CONN_KEY);
                wasConnAlreadyPresent = false;
            }
            if (!wasConnAlreadyPresent) {
                if (container.check(TRANSACTION_KEY)) throw new RuntimeException("Did not find connection but found transaction in the container!");
                t = (Transaction)container.get(TRANSACTION_KEY);
                if (t == null) {
                    t = new JdbcTransaction(conn);
                }
            } else {
                t = (Transaction)container.get(TRANSACTION_KEY);
                if (t == null) {
                    t = new JdbcTransaction(conn);
                }
            }
            if ((action = klass.newInstance()) instanceof Action) {
                Action a = (Action)action;
                BaseAction.init(a);
                a.getInput().setValue(CONN_KEY, conn);
                a.getInput().setValue(TRANSACTION_KEY, t);
            }
            container.inject(action);
            t.begin();
            Object result = template.exec(action, conn, t);
            t.commit();
            Object object = result;
            return object;
        }
        catch (Exception e) {
            try {
                if (t == null || !t.isActive()) throw new RuntimeException(e);
                t.rollback();
                throw new RuntimeException(e);
            }
            catch (Exception exp) {
                System.err.println("Could not rollback transaction!");
                exp.printStackTrace();
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (!wasConnAlreadyPresent && t != null && t.isActive()) {
                    t.end();
                }
            }
            catch (Exception e) {
                System.err.println("Cannot end transaction!");
                e.printStackTrace();
            }
            if (!wasConnAlreadyPresent) {
                container.clear(Scope.THREAD);
            }
        }
    }
}

