/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.mentawai.db.AbstractConnectionHandler;

public class JdbcConnectionHandler
extends AbstractConnectionHandler {
    private final String url;
    private final String user;
    private final String pass;

    public JdbcConnectionHandler(String url, String user, String pass) {
        this.url = url;
        this.user = user;
        this.pass = pass;
    }

    public JdbcConnectionHandler(String driver, String url, String user, String pass) {
        this(url, user, pass);
        try {
            Class.forName(driver);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.user, this.pass);
    }

    @Override
    public String getStatus() {
        return "This is not a pool, so nothing to show here!";
    }

    @Override
    public void release(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public <T> T getInstance() {
        try {
            return (T)this.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<? extends Object> getType() {
        return Connection.class;
    }

    @Override
    public void onCleared(Connection conn) {
        this.release(conn);
    }

    @Override
    public void onCreated(Connection conn) {
    }
}

