/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.mentawai.db.AbstractConnectionHandler;
import org.mentawai.db.ConnectionHandler;

public class JNDIConnectionHandler
extends AbstractConnectionHandler {
    private static Map<String, ConnectionHandler> single = new Hashtable<String, ConnectionHandler>();
    private DataSource ds = null;
    private String poolname = null;

    private JNDIConnectionHandler(String poolname) {
        try {
            InitialContext ctx = new InitialContext();
            if (ctx == null) {
                throw new RuntimeException("Context == null !!!");
            }
            this.ds = (DataSource)ctx.lookup("java:comp/env/" + poolname);
            this.poolname = poolname;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = this.ds.getConnection();
        if (conn == null) {
            throw new SQLException("Pool (" + this.poolname + ") returned null !!!");
        }
        return conn;
    }

    @Override
    public String getStatus() {
        return "Not yet implemented!";
    }

    public Object getBean() throws InstantiationException {
        try {
            return this.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<? extends Object> getType() {
        return Connection.class;
    }

    @Override
    public <T> T getInstance() {
        try {
            return (T)this.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onCleared(Connection conn) {
        this.release(conn);
    }

    @Override
    public void onCreated(Connection conn) {
    }

    @Override
    public void release(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionHandler getInstance(String poolname) {
        ConnectionHandler ch = single.get(poolname);
        if (ch == null) {
            Map<String, ConnectionHandler> map = single;
            synchronized (map) {
                ch = single.get(poolname);
                if (ch == null) {
                    ch = new JNDIConnectionHandler(poolname);
                    single.put(poolname, ch);
                }
            }
        }
        return ch;
    }

    @Override
    public void destroy() {
    }
}

