/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.db;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.mentawai.db.AbstractConnectionHandler;

public class DBCPConnectionHandler
extends AbstractConnectionHandler {
    private DataSource bds;

    public DBCPConnectionHandler(String driver, String url, String user, String pass) {
        Class<?> klass = null;
        try {
            klass = Class.forName("org.apache.commons.dbcp.BasicDataSource");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IllegalStateException("Commons DBCP cannot be found! You probably did not put the DBCP jars in your /WEB-INF/lib directory!");
        }
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IllegalStateException("Cannot find jdbc driver " + driver + "! You probably did not put your JDBC driver in your /WEB-INF/lib directory!");
        }
        try {
            Object bds = klass.newInstance();
            this.setValue(bds, "driverClassName", driver);
            this.setValue(bds, "username", user);
            this.setValue(bds, "password", pass);
            this.setValue(bds, "url", url);
            this.bds = (DataSource)bds;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error trying to setup the DBCP's BasicDataSource: " + e.getMessage(), e);
        }
    }

    @Override
    public String getStatus() {
        return "Not yet implemented!";
    }

    private void setValue(Object bean, String name, Object value) throws Exception {
        Method m;
        StringBuffer sb = new StringBuffer(30);
        sb.append("set");
        sb.append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        if ((m = bean.getClass().getMethod(sb.toString(), value.getClass())) != null) {
            m.setAccessible(true);
            m.invoke(bean, value);
        }
    }

    public DataSource getBasicDataSource() {
        return this.bds;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = this.bds.getConnection();
        if (conn == null) {
            throw new SQLException("Pool returned null !!!");
        }
        return conn;
    }

    public Object getBean() throws InstantiationException {
        try {
            return this.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T getInstance() {
        try {
            return (T)this.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onCleared(Connection conn) {
        this.release(conn);
    }

    @Override
    public void onCreated(Connection conn) {
    }

    @Override
    public Class<? extends Object> getType() {
        return Connection.class;
    }

    @Override
    public void release(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        BasicDataSource dataSource = (BasicDataSource)this.bds;
        try {
            dataSource.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

