/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.db;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DataSources;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.mentawai.db.AbstractConnectionHandler;

public class C3P0ConnectionHandler
extends AbstractConnectionHandler {
    public static boolean DEBUG = false;
    private DataSource cpds;

    public C3P0ConnectionHandler(String driver, String url, String user, String pass) {
        Class<?> klass = null;
        try {
            klass = Class.forName("com.mchange.v2.c3p0.ComboPooledDataSource");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IllegalStateException("C3P0 cannot be found! You probably did not put the C3P0 jars in your /WEB-INF/lib directory!");
        }
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IllegalStateException("Cannot find jdbc driver " + driver + "! You probably did not put your JDBC driver in your /WEB-INF/lib directory!");
        }
        try {
            Object cpds = klass.newInstance();
            this.setValue(cpds, "driverClass", driver);
            this.setValue(cpds, "user", user);
            this.setValue(cpds, "password", pass);
            this.setValue(cpds, "jdbcUrl", url);
            this.setValue(cpds, "maxIdleTime", 5);
            this.cpds = (DataSource)cpds;
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to setup a C3P0 pooled data source:" + e.getMessage(), e);
        }
    }

    public void setValue(String param, Object value) {
        try {
            this.setValue(this.cpds, param, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to setup a C3P0 pooled data source:" + e.getMessage(), e);
        }
    }

    @Override
    public String getStatus() {
        ComboPooledDataSource dataSource = (ComboPooledDataSource)this.cpds;
        try {
            StringBuilder sb = new StringBuilder(256);
            sb.append("Busy: ").append(dataSource.getNumBusyConnectionsDefaultUser());
            sb.append(" / Idle: ").append(dataSource.getNumIdleConnectionsDefaultUser());
            sb.append(" / Total: ").append(dataSource.getNumConnectionsDefaultUser());
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setValue(Object bean, String name, Object value) throws Exception {
        Method m;
        Class<Object> klass;
        StringBuffer sb = new StringBuffer(30);
        sb.append("set");
        sb.append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        if ((klass = value.getClass()).equals(Integer.class)) {
            klass = Integer.TYPE;
        }
        if ((m = bean.getClass().getMethod(sb.toString(), klass)) != null) {
            m.setAccessible(true);
            m.invoke(bean, value);
        }
    }

    public DataSource getComboPooledDataSource() {
        return this.cpds;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = this.cpds.getConnection();
        if (DEBUG) {
            new Exception("===> GOT CONN: " + conn).printStackTrace();
        }
        if (conn == null) {
            throw new SQLException("Pool returned null !!!");
        }
        return conn;
    }

    @Override
    public void onCleared(Connection conn) {
        this.release(conn);
    }

    @Override
    public void onCreated(Connection conn) {
    }

    @Override
    public Class<? extends Object> getType() {
        return Connection.class;
    }

    @Override
    public void release(Connection conn) {
        if (DEBUG) {
            new Exception("===> BYE CONN: " + conn).printStackTrace();
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public <T> T getInstance() {
        try {
            return (T)this.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object getBean() throws InstantiationException {
        try {
            return this.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void destroy() {
        ComboPooledDataSource dataSource = (ComboPooledDataSource)this.cpds;
        try {
            DataSources.destroy((DataSource)dataSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

