/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.csc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.mentawai.csc.City;
import org.mentawai.csc.Country;

public class State {
    private static Map<Integer, State> STATES = new HashMap<Integer, State>();
    private int id;
    private String name;
    private int countryId;
    private List<City> cities = null;

    public State(int id, String name, int countryId) {
        this.id = id;
        this.name = name;
        this.countryId = countryId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getCountryId() {
        return this.countryId;
    }

    public String toString() {
        return this.id + ": " + this.name;
    }

    void setCities(List<City> cities) {
        this.cities = cities;
    }

    public List<City> getCities() {
        return this.cities;
    }

    public static State getById(int id) {
        return STATES.get(id);
    }

    private static TreeMap<String, State> getTreeMap(Map<Integer, TreeMap<String, State>> cache, int countryId) {
        TreeMap<String, State> treeMap = cache.get(countryId);
        if (treeMap != null) {
            return treeMap;
        }
        treeMap = new TreeMap();
        cache.put(countryId, treeMap);
        return treeMap;
    }

    static void init() throws IOException {
        InputStream is = Country.class.getResourceAsStream("/org/mentawai/csc/states.txt");
        if (is == null) {
            throw new IOException("Cannot load states.txt");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
        HashMap<Integer, TreeMap<String, State>> cache = new HashMap<Integer, TreeMap<String, State>>();
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] s = line.split("\\t");
            int id = Integer.parseInt(s[0].trim());
            int countryId = Integer.parseInt(s[1].trim());
            String name = s[2].trim();
            State state = new State(id, name, countryId);
            STATES.put(id, state);
            TreeMap<String, State> treeMap = State.getTreeMap(cache, countryId);
            treeMap.put(name, state);
        }
        Iterator iter = cache.keySet().iterator();
        while (iter.hasNext()) {
            int countryId = (Integer)iter.next();
            TreeMap treeMap = (TreeMap)cache.get(countryId);
            ArrayList<State> states = new ArrayList<State>(treeMap.size());
            Iterator iter2 = treeMap.values().iterator();
            while (iter2.hasNext()) {
                states.add((State)iter2.next());
            }
            Country c = Country.getById(countryId);
            c.setStates(states);
        }
    }
}

