/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.csc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.mentawai.csc.City;
import org.mentawai.csc.State;
import org.mentawai.list.ListData;
import org.mentawai.list.LocalizedListData;

public class Country {
    private static Map<Integer, Country> COUNTRIES = new HashMap<Integer, Country>();
    private static Map<Locale, List<Country>> COUNTRIES_BY_LOCALE = new HashMap<Locale, List<Country>>();
    private static Set<Locale> LOCALES = new HashSet<Locale>();
    private int id;
    private Map<Locale, String> names = new HashMap<Locale, String>();
    private List<State> states = null;
    private boolean hasStates;

    public Country(int id, boolean hasStates) {
        this.id = id;
        this.hasStates = hasStates;
    }

    public Country(int id) {
        this(id, false);
    }

    public int getId() {
        return this.id;
    }

    public boolean hasStates() {
        return this.hasStates;
    }

    public boolean getHasStates() {
        return this.hasStates;
    }

    public void addName(Locale loc, String name) {
        this.names.put(loc, name);
    }

    public String getName(Locale loc) {
        return this.names.get(loc);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.id).append(" (").append(this.hasStates).append("):").append("\t");
        Iterator<String> iter = this.names.values().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append("\t");
        }
        return sb.toString();
    }

    void setStates(List<State> states) {
        Iterator<State> iter = states.iterator();
        ArrayList<State> list = new ArrayList<State>(states.size());
        while (iter.hasNext()) {
            State s = iter.next();
            State clone = new State(s.getId(), s.getName(), this.id);
            list.add(clone);
        }
        this.states = list;
    }

    public List<State> getStates() {
        return this.states;
    }

    public static Country getById(int id) {
        return COUNTRIES.get(id);
    }

    public static Iterator<Country> getCountries(Locale loc) {
        List<Country> list = COUNTRIES_BY_LOCALE.get(loc);
        if (list == null) {
            Locale l = new Locale(loc.getLanguage());
            list = COUNTRIES_BY_LOCALE.get(l);
        }
        if (list == null) {
            return null;
        }
        return list.iterator();
    }

    public static ListData getListData(String name) {
        LocalizedListData list = new LocalizedListData(name);
        return Country.getListData(list);
    }

    public static ListData getListData(LocalizedListData list) {
        for (Locale loc : COUNTRIES_BY_LOCALE.keySet()) {
            List<Country> countries = COUNTRIES_BY_LOCALE.get(loc);
            for (Country c : countries) {
                list.add(c.getId(), c.getName(loc), loc);
            }
        }
        return list;
    }

    public static Set<Locale> getLocales() {
        return LOCALES;
    }

    public static void init() throws IOException {
        String[] ss;
        InputStream is = Country.class.getResourceAsStream("/org/mentawai/csc/countries.txt");
        if (is == null) {
            throw new IOException("Cannot load countries.txt");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
        String header = br.readLine();
        String[] s = header.split("\\t");
        Locale[] locales = new Locale[s.length - 2];
        ArrayList treeMaps = new ArrayList(s.length - 2);
        for (int i = 2; i < s.length; ++i) {
            ss = s[i].split("_");
            locales[i - 2] = new Locale(ss[ss.length - 2], ss[ss.length - 1]);
            LOCALES.add(locales[i - 2]);
            treeMaps.add(new TreeMap());
        }
        String line = null;
        while ((line = br.readLine()) != null) {
            ss = line.split("\\t");
            int id = Integer.parseInt(ss[0].trim());
            boolean hasStates = ss[1].trim().equals("T");
            Country c = new Country(id, hasStates);
            for (int i = 0; i < locales.length; ++i) {
                String name = ss[2 + i].trim();
                c.addName(locales[i], name);
                TreeMap treeMap = (TreeMap)treeMaps.get(i);
                treeMap.put(name, c);
            }
            COUNTRIES.put(id, c);
        }
        for (int i = 0; i < locales.length; ++i) {
            TreeMap treeMap = (TreeMap)treeMaps.get(i);
            Iterator iter = treeMap.values().iterator();
            ArrayList list = new ArrayList(treeMap.size());
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            COUNTRIES_BY_LOCALE.put(locales[i], list);
        }
        State.init();
        City.init();
    }

    public static void main(String[] args) throws Exception {
        Country.init();
        Iterator<Country> iter = Country.getCountries(new Locale("pt"));
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
        System.out.println();
        Country c = Country.getById(53);
        System.out.println(c);
        Iterator<State> states = c.getStates().iterator();
        while (states.hasNext()) {
            System.out.println(states.next());
        }
        State s = State.getById(333);
        Iterator<City> cities = s.getCities().iterator();
        while (cities.hasNext()) {
            System.out.println(cities.next());
        }
    }
}

