/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.csc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.mentawai.csc.Country;
import org.mentawai.csc.State;

public class City {
    private static Map<Integer, City> CITIES = new HashMap<Integer, City>();
    private int id;
    private String name;
    private boolean isCapital;
    private int stateId;

    public City(int id, String name, int stateId, boolean isCapital) {
        this.id = id;
        this.name = name;
        this.stateId = stateId;
        this.isCapital = isCapital;
    }

    public int getId() {
        return this.id;
    }

    public boolean isCapital() {
        return this.isCapital;
    }

    public String getName() {
        return this.name;
    }

    public int getStateId() {
        return this.stateId;
    }

    public String toString() {
        return this.id + ": " + this.name;
    }

    public static City getById(int id) {
        return CITIES.get(id);
    }

    private static TreeMap<String, City> getTreeMap(Map<Integer, TreeMap<String, City>> cache, int stateId) {
        TreeMap<String, City> treeMap = cache.get(stateId);
        if (treeMap != null) {
            return treeMap;
        }
        treeMap = new TreeMap();
        cache.put(stateId, treeMap);
        return treeMap;
    }

    static void init() throws IOException {
        InputStream is = Country.class.getResourceAsStream("/org/mentawai/csc/cities.txt");
        if (is == null) {
            throw new IOException("Cannot load cities.txt");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
        HashMap<Integer, TreeMap<String, City>> cache = new HashMap<Integer, TreeMap<String, City>>();
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] s = line.split("\\t");
            int id = Integer.parseInt(s[0].trim());
            int stateId = Integer.parseInt(s[1].trim());
            String name = s[2].trim();
            boolean isCapital = s[3].trim().equals("T");
            City city = new City(id, name, stateId, isCapital);
            CITIES.put(id, city);
            TreeMap<String, City> treeMap = City.getTreeMap(cache, stateId);
            treeMap.put(name, city);
        }
        Iterator iter = cache.keySet().iterator();
        while (iter.hasNext()) {
            int stateId = (Integer)iter.next();
            TreeMap treeMap = (TreeMap)cache.get(stateId);
            ArrayList<City> cities = new ArrayList<City>(treeMap.size());
            City capital = City.removeCapital(treeMap);
            if (capital != null) {
                cities.add(capital);
            }
            Iterator iter2 = treeMap.values().iterator();
            while (iter2.hasNext()) {
                cities.add((City)iter2.next());
            }
            State state = State.getById(stateId);
            state.setCities(cities);
        }
    }

    private static City removeCapital(TreeMap<String, City> treeMap) {
        Iterator<City> iter = treeMap.values().iterator();
        while (iter.hasNext()) {
            City c = iter.next();
            if (!c.isCapital()) continue;
            iter.remove();
            return c;
        }
        return null;
    }
}

