/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.core.Action;
import org.mentawai.core.Consequence;
import org.mentawai.core.ConsequenceException;
import org.mentawai.core.Output;

public class StreamConsequence
implements Consequence {
    public static final String STREAM = "stream";
    public static final String CONTENT_DISPOSITION = "contentDisposition";
    public static final String CONTENT_LENGTH = "contentLength";
    public static final String CONTENT_TYPE = "contentType";
    public static final String FILENAME = "filename";
    private String contentType;
    private String keyForStream = "stream";
    private String keyForContentDisposition = "contentDisposition";
    private String keyForContentLength = "contentLength";
    private String keyForContentType = "contentType";
    private String keyForFilename = "filename";

    public StreamConsequence() {
    }

    public StreamConsequence(String contentType) {
        this.contentType = contentType;
    }

    public StreamConsequence keyForFilename(String key) {
        this.keyForFilename = key;
        return this;
    }

    public StreamConsequence keyForContentType(String key) {
        this.keyForContentType = key;
        return this;
    }

    public StreamConsequence keyForContentDisposition(String key) {
        this.keyForContentDisposition = key;
        return this;
    }

    public StreamConsequence keyForContentLength(String key) {
        this.keyForContentLength = key;
        return this;
    }

    public StreamConsequence keyForStream(String key) {
        this.keyForStream = key;
        return this;
    }

    @Override
    public void execute(Action a, String result, HttpServletRequest req, HttpServletResponse res) throws ConsequenceException {
        block11: {
            Output output = a.getOutput();
            Object obj = null;
            if (this.keyForStream != null && output.has(this.keyForStream)) {
                obj = output.getValue(this.keyForStream);
            } else {
                Iterator<String> iter = output.keys();
                while (iter.hasNext()) {
                    String key = iter.next();
                    Object value = output.getValue(key);
                    if (!(value instanceof InputStream) && !(value instanceof byte[])) continue;
                    obj = value;
                    break;
                }
            }
            if (obj instanceof byte[] && !output.has(this.keyForContentLength)) {
                byte[] array = (byte[])obj;
                output.setValue(this.keyForContentLength, array.length);
            }
            this.defineHeader(res, output);
            ServletOutputStream outputStream = null;
            try {
                outputStream = res.getOutputStream();
            }
            catch (IOException e) {
                throw new ConsequenceException(e);
            }
            try {
                if (obj instanceof InputStream) {
                    InputStream in = (InputStream)obj;
                    byte[] buffer = new byte[4092];
                    int size = 0;
                    while ((size = in.read(buffer, 0, buffer.length)) != -1) {
                        outputStream.write(buffer, 0, size);
                    }
                    outputStream.flush();
                    break block11;
                }
                if (obj instanceof byte[]) {
                    byte[] b = (byte[])obj;
                    outputStream.write(b);
                    outputStream.flush();
                    break block11;
                }
                throw new ConsequenceException("Cannot find stream: " + this.keyForStream);
            }
            catch (Exception e) {
                throw new ConsequenceException(e);
            }
        }
    }

    protected void defineHeader(HttpServletResponse res, Output output) throws ConsequenceException {
        if (this.contentType == null) {
            Object o = output.getValue(this.keyForContentType);
            if (o == null || !(o instanceof String)) {
                throw new ConsequenceException("Content-type not defined!");
            }
            res.setContentType(o.toString());
        } else {
            res.setContentType(this.contentType);
        }
        Object contentLength = output.getValue(this.keyForContentLength);
        if (contentLength != null && contentLength instanceof Number) {
            res.setContentLength(((Number)contentLength).intValue());
        }
        Object contentDisposition = output.getValue(this.keyForContentDisposition);
        Object filename = output.getValue(this.keyForFilename);
        if (filename != null) {
            res.setHeader("Content-Disposition", "inline;filename=" + filename);
        } else if (contentDisposition == null) {
            res.setHeader("Content-Disposition", "inline");
        } else {
            res.setHeader("Content-Disposition", contentDisposition.toString());
        }
    }
}

