/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mentawai.core.Context;
import org.mentawai.util.EnumerationToIterator;

public class SessionContext
implements Context,
Map<String, Object> {
    private HttpSession session;
    private HttpServletRequest req;
    private HttpServletResponse res;

    public SessionContext(HttpSession session) {
        this.session = session;
    }

    public SessionContext(HttpServletRequest req, HttpServletResponse res) {
        this.req = req;
        this.res = res;
        this.session = req.getSession(true);
    }

    @Override
    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.session.setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.session.removeAttribute(name);
    }

    @Override
    public void reset() {
        if (this.req == null) {
            throw new IllegalStateException("Can not be reseted, the request is not valid ! It's only a SessionWrapper at this time.");
        }
        this.session.invalidate();
        this.session = this.req.getSession(true);
    }

    public String getId() {
        return this.session.getId();
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public HttpSession getSession() {
        return this.session;
    }

    @Override
    public Iterator<String> keys() {
        return EnumerationToIterator.get(this.session.getAttributeNames());
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.session.getAttribute(name) != null;
    }

    @Override
    public void clear() {
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            this.removeAttribute(iter.next());
        }
    }

    @Override
    public boolean isEmpty() {
        int size = this.size();
        return size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.hasAttribute((String)key);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            String key = iter.next();
            Object v = this.getAttribute(key);
            if (v == null || !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            return this.getAttribute((String)key);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Set<String> keySet() {
        int size = this.size();
        if (size == 0) {
            return new HashSet<String>(0);
        }
        HashSet<String> set = new HashSet<String>(size);
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    @Override
    public Object put(String key, Object value) {
        this.setAttribute(key, value);
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof String) {
            String s = (String)key;
            Object obj = this.getAttribute(s);
            if (obj != null) {
                this.removeAttribute(s);
                return obj;
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            iter.next();
            ++size;
        }
        return size;
    }

    @Override
    public Collection<Object> values() {
        int size = this.size();
        if (size == 0) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> list = new ArrayList<Object>(size);
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            String key = iter.next();
            list.add(this.getAttribute(key));
        }
        return list;
    }
}

