/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.mentawai.core.Controller;

public class ServiceController
extends Controller {
    private static final long serialVersionUID = 4167319994749699926L;
    protected String extension = null;
    private String ext = null;

    @Override
    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
        String extension = conf.getInitParameter("extension");
        if (extension != null) {
            this.extension = extension;
            this.ext = "." + extension;
        }
    }

    protected final String getRequestURI(HttpServletRequest req) {
        String context = req.getContextPath();
        String uri = req.getRequestURI().toString();
        if (context.length() > 0 && uri.indexOf(context) == 0) {
            uri = uri.substring(context.length());
        }
        if (uri.startsWith("/") && uri.length() > 1) {
            uri = uri.substring(1);
        }
        if (uri.endsWith("/") && uri.length() > 1) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (this.extension != null && uri.endsWith(this.ext)) {
            uri = uri.substring(0, uri.length() - this.ext.length());
        }
        return uri;
    }

    @Override
    protected String getActionName(HttpServletRequest req) {
        String uri = this.getRequestURI(req);
        String[] s = uri.split("/");
        if (s.length > 0) {
            String res = s[0];
            if (res.length() > 1 && res.charAt(0) >= 'a' && res.charAt(0) <= 'z') {
                res = res.substring(0, 1).toUpperCase() + res.substring(1);
            }
            return res;
        }
        return null;
    }

    @Override
    protected String getInnerActionName(HttpServletRequest req) {
        String uri = this.getRequestURI(req);
        String[] s = uri.split("/");
        if (s.length > 0) {
            return s[s.length - 1];
        }
        return null;
    }
}

