/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Context;

public abstract class ScriptApplicationManager
extends ApplicationManager {
    private static final char SEP = File.separatorChar;
    protected String filename = null;
    protected File file = null;
    protected boolean reload = true;
    private long ts = 0L;

    @Override
    public void setReloadMode(boolean reload) {
        this.reload = reload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void service(Context appContext, HttpServletRequest req, HttpServletResponse res) {
        if (!this.reload) {
            return;
        }
        this.initScriptFile();
        if (this.ts == 0L) {
            this.ts = this.file.lastModified();
            return;
        }
        ScriptApplicationManager scriptApplicationManager = this;
        synchronized (scriptApplicationManager) {
            if (this.file.lastModified() != this.ts) {
                this.ts = this.file.lastModified();
                this.runScript(appContext);
            }
        }
    }

    protected String getFilename(String script) {
        StringBuffer sb = new StringBuffer(ScriptApplicationManager.getRealPath());
        sb.append(SEP).append("WEB-INF").append(SEP).append(script);
        return sb.toString();
    }

    private void initScriptFile() {
        if (this.file == null) {
            this.filename = this.getFilename(this.getScriptName());
            this.file = new File(this.filename);
        }
    }

    public void runScript(Context application) {
        this.initScriptFile();
        this.reset();
        this.runScript(this.filename, application);
    }

    public abstract void runScript(String var1, Context var2);

    protected abstract String getScriptName();
}

