/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.mentawai.core.AbstractInput;
import org.mentawai.core.Controller;
import org.mentawai.core.InputException;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.util.EnumerationToIterator;

public class RequestInput
extends AbstractInput
implements Map<String, Object> {
    protected Map<String, Object> map;
    protected HttpServletRequest req;
    protected static Map<String, Method> cache = null;
    protected Set<String> keys = new TreeSet<String>();

    public RequestInput(HttpServletRequest req) {
        Map map = req.getParameterMap();
        this.map = this.clone(map);
        this.req = req;
    }

    private Map<String, Object> clone(Map<String, Object> map) {
        HashMap<String, Object> clone = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            String[] array;
            Object value = map.get(key);
            if (value instanceof String[] && (array = (String[])value).length == 1) {
                value = array[0];
            }
            clone.put(key, value);
            this.keys.add(key);
        }
        return clone;
    }

    public String toString() {
        Iterator<String> iter = this.keys();
        StringBuffer sb = new StringBuffer(1024);
        while (iter.hasNext()) {
            String name = iter.next();
            String value = this.getString(name);
            value = value.replace('\n', ' ');
            sb.append(name).append(" = ").append(value).append("\n");
        }
        return sb.toString();
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    @Override
    public String getProperty(String name) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("get");
        sb.append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        String methodName = sb.toString();
        try {
            Object value;
            Method m = null;
            if (cache == null) {
                cache = new Hashtable<String, Method>();
            } else {
                m = cache.get(methodName);
            }
            if (m == null) {
                m = this.req.getClass().getMethod(methodName, new Class[0]);
                cache.put(methodName, m);
            }
            if ((value = m.invoke((Object)this.req, new Object[0])) != null) {
                return value.toString();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    @Override
    public Iterator<String> getHeaderKeys() {
        return EnumerationToIterator.get(this.req.getHeaderNames());
    }

    @Override
    public Iterator<String> keys() {
        return this.keys.iterator();
    }

    @Override
    public void removeValue(String name) {
        this.map.remove(name);
        this.keys.remove(name);
    }

    @Override
    public String getStringValue(String name) {
        return this.getString(name);
    }

    @Override
    public String getString(String name) {
        Object o = this.map.get(name);
        if (o == null) {
            return null;
        }
        return Controller.DEFAULT_CHARSET == null ? o.toString() : new String(o.toString().getBytes());
    }

    @Override
    public String[] getStringValues(String name) {
        return this.getStrings(name);
    }

    @Override
    public String[] getStrings(String name) {
        Object obj = this.map.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String[]) {
            return (String[])obj;
        }
        if (obj instanceof String) {
            String[] s = new String[]{Controller.DEFAULT_CHARSET == null ? obj.toString() : new String(obj.toString().getBytes())};
            return s;
        }
        throw new InputException("Error trying to get a String []: " + name);
    }

    @Override
    public void setValue(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot use 'null' as a key in the action input! Value = " + (value == null ? "NULL" : value.toString()));
        }
        this.map.put(name, value);
        this.keys.add(name);
    }

    @Override
    public boolean hasValue(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public boolean has(String key) {
        return this.hasValue(key);
    }

    @Override
    public Object getValue(String name) {
        return this.map.get(name);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.keys.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.map.containsKey(key);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            return this.getValue((String)key);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Set<String> keySet() {
        if (this.size() == 0) {
            return new HashSet<String>(0);
        }
        HashSet<String> set = new HashSet<String>(this.size());
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    @Override
    public Object put(String key, Object value) {
        if (key instanceof String) {
            this.setValue(key, value);
            return value;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        this.map.putAll(t);
        Iterator<? extends String> iter = t.keySet().iterator();
        while (iter.hasNext()) {
            this.keys.add(iter.next());
        }
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof String) {
            String s = (String)key;
            Object obj = this.getValue(s);
            if (obj != null) {
                this.removeValue(s);
                return obj;
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    protected Locale getLocale() {
        return LocaleManager.getLocale(this.req);
    }
}

