/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.net.URI;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.core.Action;
import org.mentawai.core.ActionConfig;
import org.mentawai.core.Consequence;
import org.mentawai.core.ConsequenceException;
import org.mentawai.core.Output;
import org.mentawai.util.ActionUtils;

public class Redirect
implements Consequence {
    public static final String REDIRURL_PARAM = "_mentawai_redirect_url";
    private String url = null;
    private boolean appendOutput = false;
    private boolean dynamicUrl = false;

    public Redirect(String url) {
        this.url = url;
    }

    public Redirect(ActionConfig ac) {
        this(ActionUtils.getUrlFrom(ac));
    }

    public Redirect(String url, boolean appendOutput) {
        this.url = url;
        this.appendOutput = appendOutput;
    }

    public Redirect(ActionConfig ac, boolean appendOutput) {
        this(ActionUtils.getUrlFrom(ac), appendOutput);
    }

    public Redirect() {
        this.dynamicUrl = true;
    }

    public Redirect(boolean appendOutput) {
        this.dynamicUrl = true;
        this.appendOutput = appendOutput;
    }

    @Override
    public void execute(Action act, String result, HttpServletRequest req, HttpServletResponse res) throws ConsequenceException {
        try {
            Output output = act != null ? act.getOutput() : null;
            String path = this.dynamicUrl && output != null ? (String)output.getValue(REDIRURL_PARAM) : this.url;
            if (path == null || path.length() == 0) {
                throw new ConsequenceException("Missing url for redirect!");
            }
            StringBuilder sb = new StringBuilder(64);
            if (path.indexOf("://") > 0) {
                sb.append(path);
            } else if (path.startsWith("//")) {
                sb.append(path.substring(1, path.length()));
            } else {
                sb.append(req.getContextPath());
                if (!path.startsWith("/")) {
                    sb.append("/");
                }
                sb.append(path);
            }
            URI uri = new URI(path);
            String urlQueryString = uri.getQuery();
            if (this.appendOutput && output != null) {
                StringBuilder queryString = new StringBuilder(64);
                Iterator<String> iter = output.keys();
                while (iter.hasNext()) {
                    Object value;
                    String key = iter.next();
                    if (key.startsWith("_") || (value = output.getValue(key)) == null) continue;
                    if (queryString.length() > 0) {
                        queryString.append('&');
                    }
                    queryString.append(key);
                    queryString.append("=");
                    queryString.append(URLEncoder.encode(value.toString(), "UTF-8"));
                }
                if (queryString.length() > 0) {
                    if (urlQueryString == null) {
                        sb.append('?').append((CharSequence)queryString);
                    } else if (urlQueryString.equals("")) {
                        sb.append((CharSequence)queryString);
                    } else {
                        sb.append('&').append((CharSequence)queryString);
                    }
                }
            }
            res.sendRedirect(sb.toString());
        }
        catch (Exception e) {
            throw new ConsequenceException(e);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Redirect to ");
        if (this.url != null) {
            s.append(this.url);
        } else {
            s.append("(dynamic url)");
        }
        if (this.appendOutput) {
            s.append(" (dynamic parameters)");
        }
        return s.toString();
    }
}

