/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.mentawai.core.ApplicationManager;

public class Props {
    public static String CHARSET = "UTF-8";
    private final Properties def = new Properties();
    private final Properties prop = new Properties();
    private final Properties local = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLocal(InputStream is) throws IOException {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, CHARSET);
            this.local.load(isr);
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDefault(InputStream is) throws IOException {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, CHARSET);
            this.def.load(isr);
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream is) throws IOException {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, CHARSET);
            this.prop.load(isr);
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String get(String key) {
        if (this.local.containsKey(key)) {
            return this.local.getProperty(key);
        }
        if (this.prop.containsKey(key)) {
            return this.prop.getProperty(key);
        }
        if (this.def.containsKey(key)) {
            return this.def.getProperty(key);
        }
        return null;
    }

    public String getString(String key) {
        return this.get(key);
    }

    public int getInt(String key) {
        String v = this.get(key);
        if (v == null) {
            throw new NullPointerException("Cannot find value for key: " + key);
        }
        return Integer.parseInt(v);
    }

    public boolean getBoolean(String key) {
        String v = this.get(key);
        if (v == null) {
            throw new NullPointerException("Cannot find value for key: " + key);
        }
        return Boolean.parseBoolean(v);
    }

    public boolean has(String key) {
        return this.get(key) != null;
    }

    public String getPath(String key) {
        String s = this.getString(key);
        if (File.separatorChar == '/') {
            return s;
        }
        return s.replaceAll("\\/", File.separator);
    }

    public String getAbsolutePath(String key) {
        String start = ApplicationManager.getRealPath();
        String s = this.getPath(key);
        if (s.startsWith(File.separator)) {
            return start + s;
        }
        return start + File.separator + s;
    }
}

