/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.core.Action;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Controller;
import org.mentawai.core.CookieContext;
import org.mentawai.core.PrettyURLRequestInput;
import org.mentawai.core.ResponseOutput;
import org.mentawai.core.SessionContext;
import org.mentawai.i18n.LocaleManager;

public class PrettyURLController
extends Controller {
    private static final long serialVersionUID = 4167310974749699926L;
    private static final String INNER_ACTION_SEPARATOR_PARAM = "innerActionSeparator";
    private static final char DEFAULT_INNER_ACTION_SEPARATOR = '-';
    private char innerActionSeparator;
    static final String EXTENSION = "." + ApplicationManager.EXTENSION;

    @Override
    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
        String innerActionSeparatorParam = conf.getInitParameter(INNER_ACTION_SEPARATOR_PARAM);
        if (innerActionSeparatorParam != null) {
            this.validateLength(innerActionSeparatorParam);
            this.validateContent(innerActionSeparatorParam);
            this.innerActionSeparator = innerActionSeparatorParam.charAt(0);
        } else {
            this.innerActionSeparator = (char)45;
        }
    }

    private void validateContent(String innerActionSeparatorParam) throws ServletException {
        if (innerActionSeparatorParam.equals("/")) {
            throw new ServletException("The innerActionSeparator context parameter cannot be the '/' char");
        }
    }

    private void validateLength(String innerActionSeparatorParam) throws ServletException {
        if (innerActionSeparatorParam.length() != 1) {
            throw new ServletException("The innerActionSeparator context parameter must have only one char");
        }
    }

    private boolean isPrettyURL(HttpServletRequest req) {
        String uri = req.getRequestURI().toString();
        if (uri.endsWith("/") && uri.length() > 1) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return !uri.endsWith(EXTENSION) && uri.indexOf(".") <= 0;
    }

    private String getActionPlusInnerAction(HttpServletRequest req) {
        String[] s;
        String context = req.getContextPath();
        String uri = req.getRequestURI().toString();
        if (context.length() > 0 && uri.indexOf(context) == 0) {
            uri = uri.substring(context.length());
        }
        if (uri.startsWith("/") && uri.length() > 1) {
            uri = uri.substring(1);
        }
        if (uri.endsWith("/") && uri.length() > 1) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if ((s = uri.split("/")).length >= 2) {
            return s[1];
        }
        return null;
    }

    @Override
    protected String getActionName(HttpServletRequest req) {
        if (!this.isPrettyURL(req)) {
            return super.getActionName(req);
        }
        String s = this.getActionPlusInnerAction(req);
        int index = s.indexOf(this.innerActionSeparator);
        if (index > 0) {
            return s.substring(0, index);
        }
        return s;
    }

    @Override
    protected String getInnerActionName(HttpServletRequest req) {
        if (!this.isPrettyURL(req)) {
            return super.getInnerActionName(req);
        }
        String s = this.getActionPlusInnerAction(req);
        int index = s.indexOf(this.innerActionSeparator);
        if (index > 0 && index + 1 < s.length()) {
            return s.substring(index + 1);
        }
        return null;
    }

    @Override
    protected void prepareAction(Action action, HttpServletRequest req, HttpServletResponse res) {
        if (!this.isPrettyURL(req)) {
            super.prepareAction(action, req, res);
            return;
        }
        action.setInput(new PrettyURLRequestInput(req));
        action.setOutput(new ResponseOutput(res));
        action.setSession(new SessionContext(req, res));
        action.setApplication(appContext);
        action.setCookies(new CookieContext(req, res));
        action.setLocale(LocaleManager.getLocale(req));
    }
}

