/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.mentawai.core.AbstractInput;
import org.mentawai.core.InputException;

public class MapInput
extends AbstractInput {
    private Map<String, String> headers = null;
    private Map<String, Object> values;
    private Map<String, String> properties = null;
    private Locale loc = Locale.ENGLISH;

    public MapInput() {
        this.values = new HashMap<String, Object>();
    }

    public MapInput(Map<String, Object> values) {
        this.values = values;
    }

    public void setLocale(Locale loc) {
        this.loc = loc;
    }

    public void setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    @Override
    public String getHeader(String name) {
        if (this.headers != null) {
            return this.headers.get(name);
        }
        return null;
    }

    @Override
    public Iterator<String> getHeaderKeys() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        return this.headers.keySet().iterator();
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value);
    }

    @Override
    public String getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    @Override
    public boolean hasValue(String name) {
        return this.values.containsKey(name);
    }

    @Override
    public boolean has(String key) {
        return this.hasValue(key);
    }

    @Override
    public String getStringValue(String name) {
        return this.getString(name);
    }

    @Override
    public String getString(String name) {
        Object value = this.values.get(name);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public Iterator<String> keys() {
        return this.values.keySet().iterator();
    }

    @Override
    public void removeValue(String name) {
        this.values.remove(name);
    }

    @Override
    public String[] getStringValues(String name) {
        return this.getStrings(name);
    }

    @Override
    public String[] getStrings(String name) {
        Object obj = this.values.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String[]) {
            return (String[])obj;
        }
        if (obj instanceof String) {
            String[] s = new String[]{(String)obj};
            return s;
        }
        throw new InputException("Error trying to get a String []: " + name);
    }

    @Override
    public void setValue(String name, Object value) {
        this.values.put(name, value);
    }

    @Override
    public Object getValue(String name) {
        return this.values.get(name);
    }

    @Override
    protected Locale getLocale() {
        return this.loc;
    }
}

