/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mentawai.core.Action;
import org.mentawai.core.ActionConfig;
import org.mentawai.core.ActionException;
import org.mentawai.core.Controller;
import org.mentawai.core.Filter;
import org.mentawai.core.Input;
import org.mentawai.core.PojoAction;
import org.mentawai.filter.MethodParamFilter;
import org.mentawai.jruby.JRubyInterpreter;
import org.mentawai.jruby.RubyAction;
import org.mentawai.util.DebugServletFilter;
import org.mentawai.util.InjectionUtils;

public class InvocationChain {
    private LinkedList<Filter> filters = new LinkedList();
    private Action action;
    private String innerAction = null;
    private final String actionName;
    private ActionConfig actionConfig;

    public InvocationChain(String actionName, Action action, ActionConfig ac) {
        this.actionName = actionName;
        this.action = action;
        this.actionConfig = ac;
    }

    public ActionConfig getActionConfig() {
        return this.actionConfig;
    }

    public Filter getFilter(Class<? extends Filter> filterClass) {
        for (Filter f : this.filters) {
            if (!filterClass.isAssignableFrom(f.getClass())) continue;
            return f;
        }
        return null;
    }

    public Action getAction() {
        return this.action;
    }

    public Object getPojo() {
        if (this.action instanceof PojoAction) {
            PojoAction pa = (PojoAction)this.action;
            return pa.getPojo();
        }
        return null;
    }

    void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    void addFilters(List<Filter> list) {
        this.filters.addAll(list);
    }

    void clearFilters() {
        this.filters.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String invoke() throws Exception {
        if (Controller.debugMode) {
            DebugServletFilter.debugInputOutput(this.action);
        }
        if (!this.filters.isEmpty()) {
            Filter f = this.filters.removeFirst();
            if (!Controller.debugMode) return f.filter(this);
            StringBuffer sb = DebugServletFilter.getDebug(this.action);
            DebugServletFilter.debug(sb, f);
            return f.filter(this);
        }
        if (Controller.debugMode) {
            StringBuffer sb = DebugServletFilter.getDebug(this.action);
            DebugServletFilter.debug(sb, this.innerAction, false);
        }
        String result = null;
        if (this.action instanceof RubyAction) {
            JRubyInterpreter ruby = JRubyInterpreter.getInstance();
            RubyAction rubyAction = (RubyAction)this.action;
            Object rubyObject = rubyAction.getRubyObject();
            if (this.innerAction == null) return ruby.callAction(rubyObject, "execute");
            return ruby.callAction(rubyObject, this.innerAction);
        }
        Object pojo = null;
        boolean isPojoAction = false;
        if (this.action instanceof PojoAction) {
            PojoAction pa = (PojoAction)this.action;
            pojo = pa.getPojo();
            isPojoAction = true;
        } else {
            pojo = this.action;
        }
        String methodToExec = this.innerAction;
        if (methodToExec == null) {
            methodToExec = "execute";
        }
        Method[] m = pojo.getClass().getMethods();
        for (int i = 0; i < m.length; ++i) {
            if (!Modifier.isPublic(m[i].getModifiers()) || !m[i].getName().equals(methodToExec)) continue;
            Method theOne = m[i];
            Class<?>[] params = theOne.getParameterTypes();
            Input input = this.action.getInput();
            Object[] paramValues = new Object[params.length];
            HashSet<String> paramKeys = new HashSet<String>();
            for (int j = 0; j < params.length; ++j) {
                boolean found = false;
                List list = (List)input.getValue(MethodParamFilter.PARAM_KEY);
                Iterator<String> keys = list == null ? input.keys() : list.iterator();
                while (keys.hasNext()) {
                    String key = keys.next();
                    if (paramKeys.contains(key)) continue;
                    Object o = input.getValue(key);
                    if (params[j].isInstance(o)) {
                        paramValues[j] = o;
                        paramKeys.add(key);
                        found = true;
                        break;
                    }
                    Object converted = InjectionUtils.tryToConvert(o, params[j], this.action.getLocale(), true);
                    if (converted == null) continue;
                    paramValues[j] = converted;
                    paramKeys.add(key);
                    found = true;
                    break;
                }
                if (!found && !params[j].getName().startsWith("java.lang.") && !params[j].isPrimitive() && InjectionUtils.hasDefaultConstructor(params[j])) {
                    Class<?> obj = this.action.getInput().getObject(params[j]);
                    String key = params[j].getSimpleName().toLowerCase();
                    paramKeys.add(key);
                    paramValues[j] = obj;
                    this.action.getInput().setValue(key, obj);
                    found = true;
                }
                if (found) continue;
                throw new ActionException("Cannot find parameter value for method: " + methodToExec + " / " + params[j]);
            }
            Object retval = theOne.invoke(pojo, paramValues);
            if (theOne.getReturnType() == null) return "success";
            if (theOne.getReturnType().equals(Void.TYPE)) {
                return "success";
            }
            if (theOne.getReturnType() == null) return retval.toString();
            if (theOne.getReturnType().equals(String.class)) {
                return retval.toString();
            }
            this.action.getOutput().setValue(PojoAction.RESULT, retval);
            if (retval != null) return retval.toString();
            return "null";
        }
        if (isPojoAction) {
            throw new ActionException("Cannot find method to execute: " + methodToExec);
        }
        if (this.innerAction != null) {
            Class<Action> klass = this.getInnerClass(this.innerAction);
            if (klass != null) {
                Constructor c = this.getConstructor(klass);
                if (c == null) {
                    throw new ActionException("The inner class for this inner action does not have a constructor: " + this.innerAction);
                }
                Class<?>[] paramTypes = c.getParameterTypes();
                if (paramTypes.length == 0) {
                    try {
                        Action innerActionClass = klass.newInstance();
                        this.initInnerAction(this.action, innerActionClass);
                        Method executeMethod = this.getMethod(innerActionClass, "execute");
                        if (executeMethod == null) throw new ActionException("The static inner action class does not have the execute method!");
                        return (String)executeMethod.invoke((Object)innerActionClass, (Object[])null);
                    }
                    catch (ActionException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ActionException(e);
                    }
                }
                if (paramTypes.length != 1) return result;
                try {
                    Action innerActionClass = (Action)c.newInstance(this.action);
                    this.initInnerAction(this.action, innerActionClass);
                    Method executeMethod = this.getMethod(innerActionClass, "execute");
                    if (executeMethod == null) throw new ActionException("The innerAction class does not have the execute method!");
                    return (String)executeMethod.invoke((Object)innerActionClass, (Object[])null);
                }
                catch (ActionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ActionException(e);
                }
            }
            Method method = this.getMethod(this.innerAction);
            if (method == null) throw new ActionException("The inner action does not exist: " + this.innerAction);
            try {
                return (String)method.invoke((Object)this.action, (Object[])null);
            }
            catch (Exception e) {
                throw new ActionException(e);
            }
        }
        Method method = this.getMethod(this.action, "execute");
        if (method == null) throw new ActionException("The action does not implement the execute method!");
        try {
            return (String)method.invoke((Object)this.action, (Object[])null);
        }
        catch (Exception e) {
            throw new ActionException(e);
        }
    }

    protected void initInnerAction(Action mainAction, Action innerAction) {
        innerAction.setInput(mainAction.getInput());
        innerAction.setOutput(mainAction.getOutput());
        innerAction.setSession(mainAction.getSession());
        innerAction.setApplication(mainAction.getApplication());
        innerAction.setCookies(mainAction.getCookies());
        innerAction.setLocale(mainAction.getLocale());
    }

    private Constructor getConstructor(Class<Action> klass) {
        Constructor<Action> c = null;
        try {
            c = klass.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (c != null) {
            return c;
        }
        try {
            c = klass.getConstructor(this.action.getClass());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return c;
    }

    private Class<Action> getInnerClass(String innerAction) {
        Class<?>[] classes;
        for (Class<Action> clazz : classes = this.action.getClass().getClasses()) {
            String simpleName = clazz.getSimpleName();
            if (!Action.class.isAssignableFrom(clazz) || !simpleName.equals(innerAction) && !simpleName.equalsIgnoreCase(innerAction)) continue;
            return clazz;
        }
        return null;
    }

    private Method getMethod(String innerAction) {
        return this.getMethod(this.action, innerAction);
    }

    private Method getMethod(Object action, String innerAction) {
        try {
            Method m = action.getClass().getMethod(innerAction, null);
            if (m != null) {
                return m;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setInnerAction(String innerAction) {
        this.innerAction = innerAction;
    }

    public String getInnerAction() {
        return this.innerAction;
    }

    public String getActionName() {
        return this.actionName;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }
}

