/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.core.Action;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Consequence;
import org.mentawai.core.ConsequenceException;
import org.mentawai.core.Controller;
import org.mentawai.core.Output;

public class Forward
implements Consequence {
    public static String ACTION_REQUEST = "action";
    public static String SESSION_REQUEST = "session";
    public static String APPLICATION_REQUEST = "application";
    public static String INPUT_REQUEST = "input";
    private String url;

    public Forward(String url) {
        this.url = this.putSlash(url);
        String viewDir = ApplicationManager.getViewDir();
        if (viewDir != null) {
            if (viewDir.endsWith("/") && viewDir.length() > 1) {
                viewDir = viewDir.substring(0, viewDir.length() - 1);
            }
            this.url = this.putSlash(viewDir) + this.url;
        }
    }

    private String putSlash(String url) {
        if (url != null && !url.startsWith("/")) {
            return "/" + url;
        }
        return url;
    }

    @Override
    public void execute(Action a, String result, HttpServletRequest req, HttpServletResponse res) throws ConsequenceException {
        try {
            if (a != null) {
                Output output = a.getOutput();
                Iterator<String> iter = output.keys();
                while (iter.hasNext()) {
                    String key = iter.next();
                    Object value = output.getValue(key);
                    req.setAttribute(key, value);
                }
                req.setAttribute(APPLICATION_REQUEST, (Object)a.getApplication());
                req.setAttribute(SESSION_REQUEST, (Object)a.getSession());
                req.setAttribute(INPUT_REQUEST, (Object)a.getInput());
                req.setAttribute(ACTION_REQUEST, (Object)a);
            }
            Forward.forward(this.url, req, res);
        }
        catch (Exception e) {
            throw new ConsequenceException(e);
        }
    }

    public static void forward(String url, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletContext app = Controller.getApplication();
        RequestDispatcher rd = app.getRequestDispatcher(url);
        rd.forward((ServletRequest)req, (ServletResponse)res);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("Forward to ").append(this.url);
        return sb.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = this.putSlash(url);
    }
}

