/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.core.Context;

public class CookieContext
implements Context,
Map<String, Object> {
    private HttpServletRequest req;
    private HttpServletResponse res;

    public CookieContext(HttpServletRequest req, HttpServletResponse res) {
        this.req = req;
        this.res = res;
    }

    @Override
    public Object getAttribute(String name) {
        Cookie[] cookies = this.req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(name)) continue;
                return cookies[i].getValue();
            }
        }
        return null;
    }

    @Override
    public Iterator<String> keys() {
        ArrayList<String> list = new ArrayList<String>();
        Cookie[] cookies = this.req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                list.add(cookies[i].getName());
            }
        }
        return list.iterator();
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (value instanceof Cookie) {
            this.res.addCookie((Cookie)value);
        } else {
            Cookie c = new Cookie(name, value.toString());
            c.setMaxAge(31104000);
            c.setPath("/");
            this.res.addCookie(c);
        }
    }

    @Override
    public void removeAttribute(String name) {
        Cookie c = new Cookie(name, "");
        c.setMaxAge(0);
        this.res.addCookie(c);
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("reset() is not supported by CookieContext !");
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getAttribute(key.toString()) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        String v = value.toString();
        Cookie[] cookies = this.req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                String cookie = cookies[i].getValue();
                if (cookie == null || !cookie.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        Object value = this.getAttribute(key.toString());
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean isEmpty() {
        Cookie[] cookies = this.req.getCookies();
        return cookies == null || cookies.length == 0;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            keys.add(iter.next());
        }
        return keys;
    }

    @Override
    public String put(String key, Object value) {
        this.setAttribute(key, value);
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String remove(Object key) {
        this.removeAttribute(key.toString());
        return null;
    }

    @Override
    public int size() {
        Cookie[] cookies = this.req.getCookies();
        if (cookies == null) {
            return 0;
        }
        return cookies.length;
    }

    @Override
    public Collection<Object> values() {
        Cookie[] cookies = this.req.getCookies();
        if (cookies == null || cookies.length == 0) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> list = new ArrayList<Object>(cookies.length);
        for (int i = 0; i < cookies.length; ++i) {
            list.add(cookies[i].getValue());
        }
        return list;
    }
}

