/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.mentaregex.Regex;
import org.mentawai.coc.ConsequenceProvider;
import org.mentawai.coc.DefaultConsequenceProvider;
import org.mentawai.core.Action;
import org.mentawai.core.ActionConfig;
import org.mentawai.core.ActionException;
import org.mentawai.core.AfterConsequenceFilter;
import org.mentawai.core.ApplicationContext;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.ApplicationManagerViewer;
import org.mentawai.core.BaseAction;
import org.mentawai.core.Consequence;
import org.mentawai.core.Context;
import org.mentawai.core.CookieContext;
import org.mentawai.core.Filter;
import org.mentawai.core.GlobalFilterFree;
import org.mentawai.core.InputWrapper;
import org.mentawai.core.InvocationChain;
import org.mentawai.core.Redirect;
import org.mentawai.core.RequestInput;
import org.mentawai.core.ResponseOutput;
import org.mentawai.core.SessionContext;
import org.mentawai.core.StickyAction;
import org.mentawai.filter.GlobalFilterFreeMarkerFilter;
import org.mentawai.formatter.FormatterManager;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.jruby.JRubyInterpreter;
import org.mentawai.list.ListManager;
import org.mentawai.log.Debug;
import org.mentawai.log.Info;
import org.mentawai.util.DebugServletFilter;

public class Controller
extends HttpServlet {
    private static final long serialVersionUID = 5571457670768805678L;
    public static String DEFAULT_CHARSET = null;
    private static final char SEP = File.separatorChar;
    private static ApplicationManager appManager = null;
    private static String appMgrClassname = null;
    private static ServletContext application = null;
    private static ServletConfig config = null;
    protected static ApplicationContext appContext = null;
    private static ConsequenceProvider consequenceProvider = null;
    private static ConsequenceProvider defaultConsequenceProvider = new DefaultConsequenceProvider();
    private static File appManagerFile = null;
    private static long lastModified = 0L;
    static boolean reloadAppManager = false;
    static boolean debugMode = false;
    static boolean autoView = false;
    static boolean statsMode = false;
    private static final String STICKY_KEY = "_stickyActions";
    private static final String[] APP_MGR_NAMES = new String[]{"ApplicationManager", "AppMgr", "AppManager"};

    public void init(ServletConfig conf) throws ServletException {
        String stats;
        String auto;
        String debug;
        super.init(conf);
        config = conf;
        application = conf.getServletContext();
        appContext = new ApplicationContext(application);
        ApplicationManager.setRealPath(application.getRealPath(""));
        String reload = config.getInitParameter("reloadAppManager");
        if (reload != null && reload.equalsIgnoreCase("true")) {
            reloadAppManager = true;
        }
        if ((debug = config.getInitParameter("debugMode")) != null && debug.equalsIgnoreCase("true")) {
            debugMode = true;
        }
        if ((auto = config.getInitParameter("autoView")) != null && auto.equalsIgnoreCase("true")) {
            autoView = true;
        }
        if ((stats = config.getInitParameter("stats")) != null && stats.equalsIgnoreCase("true")) {
            statsMode = true;
        }
        appMgrClassname = config.getInitParameter("applicationManager");
        Debug.log("[Controller] ApplicationManager from web.xml = " + appMgrClassname);
        if (appMgrClassname == null || appMgrClassname.trim().equals("")) {
            boolean found = false;
            Debug.log("[Controller] Nothing in web.xml finding classes '" + APP_MGR_NAMES + "' in default package...");
            for (int i = 0; i < APP_MGR_NAMES.length; ++i) {
                String classname = APP_MGR_NAMES[i];
                try {
                    Class<?> klass = Class.forName(classname);
                    if (!ApplicationManager.class.isAssignableFrom(klass)) continue;
                    appMgrClassname = new String(classname);
                    found = true;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!found) {
                Debug.log("[Controller] Nothing  found in default package, Scanning the classpath in search of ApplicationManager");
                try {
                    found = this.findAppMgr(new File(ApplicationManager.getRealPath() + SEP + "WEB-INF" + SEP + "classes"));
                }
                catch (Exception e) {
                    System.err.println("Erro looking for ApplicationManager.class!");
                    e.printStackTrace();
                }
            }
            if (!found) {
                appMgrClassname = "ApplicationManager";
            }
        }
        Info.log("[Controller] Initializing ApplicationManager from class: " + appMgrClassname);
        Controller.initApplicationManager();
    }

    public static String getBasePathForMaven() {
        String mvn = SEP + "src" + SEP + "main" + SEP + "webapp";
        if (ApplicationManager.getRealPath().endsWith(mvn)) {
            int index = ApplicationManager.getRealPath().indexOf(mvn);
            String base = ApplicationManager.getRealPath().substring(0, index);
            return base;
        }
        return null;
    }

    public static ServletConfig getConfig() {
        return config;
    }

    private boolean findAppMgr(File f) throws IOException {
        if (f.isDirectory()) {
            File[] childs;
            String filename = f.toString();
            String[] s = Regex.match(filename, "/WEB#-INF#" + SEP + "classes#" + SEP + "(.+)/", '#');
            if (s != null && s.length == 1) {
                filename = s[0];
                filename = filename.replace(SEP, '.');
                for (int i = 0; i < APP_MGR_NAMES.length; ++i) {
                    String classname = filename + "." + APP_MGR_NAMES[i];
                    try {
                        Class<?> klass = Class.forName(classname);
                        if (ApplicationManager.class.isAssignableFrom(klass)) {
                            appMgrClassname = new String(classname);
                            return true;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            for (File child : childs = f.listFiles()) {
                boolean found = this.findAppMgr(child);
                if (!found) continue;
                return true;
            }
        }
        return false;
    }

    public static void setConsequenceProvider(ConsequenceProvider provider) {
        consequenceProvider = provider;
    }

    public static ConsequenceProvider getConsequenceProvider() {
        return consequenceProvider;
    }

    private static File findAppManagerClass() {
        StringBuilder sb = new StringBuilder(ApplicationManager.getRealPath());
        sb.append(SEP).append("WEB-INF").append(SEP).append("classes").append(SEP);
        sb.append(appMgrClassname.replace('.', SEP)).append(".class");
        File f = new File(sb.toString());
        if (f.exists()) {
            return f;
        }
        try {
            Class<?> forName = Class.forName(appMgrClassname);
            String base = forName.getResource("/").getPath();
            sb.setLength(0);
            sb.append(base).append(appMgrClassname.replace('.', SEP)).append(".class");
            f = new File(sb.toString());
            if (f.exists()) {
                return f;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        String base = Controller.getBasePathForMaven();
        if (base != null) {
            sb.setLength(0);
            sb.append(base).append(SEP).append("target").append(SEP).append("classes").append(SEP);
            sb.append(appMgrClassname.replace('.', SEP)).append(".class");
            File ff = new File(sb.toString());
            if (ff.exists()) {
                return ff;
            }
        }
        return f;
    }

    private static boolean isAppMgrModified() {
        if (appManagerFile == null) {
            appManagerFile = Controller.findAppManagerClass();
        }
        if (!appManagerFile.exists()) {
            return false;
        }
        if (lastModified == 0L) {
            lastModified = appManagerFile.lastModified();
        }
        if (appManagerFile.lastModified() != lastModified) {
            lastModified = appManagerFile.lastModified();
            return true;
        }
        return false;
    }

    private static void printInfoHeader() {
        System.out.println();
        System.out.println("==== [ Mentawai :: MVC WEB Framework ] ==========================================================");
        System.out.println("- Version : 2.2.2 (20111018)");
        System.out.println("- ReloadAppManager: " + reloadAppManager);
        System.out.println("- DebugMode: " + debugMode);
        System.out.println("- AutoView: " + autoView);
        System.out.println("- ApplicationManager: " + appMgrClassname);
        System.out.println("------------------------------------------------------------------------------------");
        System.out.println("- Server: " + application.getServerInfo());
        if (Controller.getContextPath() != null) {
            System.out.println("- ApplicationContext: " + Controller.getContextPath());
        }
        System.out.println("- Environment: " + (Object)((Object)appManager.getEnvironment()));
        System.out.println("==================================================================================================");
        System.out.println();
    }

    private static String getContextPath() {
        String s = ApplicationManager.getContextPath();
        if (s == null) {
            return null;
        }
        if (s.equals("")) {
            return "ROOT";
        }
        return s;
    }

    private static void initApplicationManager() throws ServletException {
        try {
            Class<?> klass = Class.forName(appMgrClassname);
            appManager = (ApplicationManager)klass.newInstance();
            ApplicationManager.setApplication(appContext);
            appManager.init(appContext);
            DebugServletFilter.addStaticInfo("Environment = " + appManager.getEnvironment().toString());
            appManager.setupDB();
            appManager.loadBeans();
            appManager.loadLocales();
            appManager.loadFilters();
            appManager.setupIoC();
            appManager.loadActions();
            ListManager.init();
            appManager.loadLists();
            FormatterManager.init();
            appManager.loadFormatters();
            appManager.onStarted(appContext);
            Controller.printInfoHeader();
            DebugServletFilter.addStaticInfo("ApplicationManager = " + appMgrClassname);
            DebugServletFilter.addStaticInfo("ReloadAppManager = " + reloadAppManager);
            DebugServletFilter.addStaticInfo("AutoView = " + autoView);
            DebugServletFilter.addStaticInfo("Version = 2.2.2 (20111018)");
            if (Controller.getContextPath() != null) {
                DebugServletFilter.addStaticInfo("ContextPath = " + Controller.getContextPath());
            }
            DebugServletFilter.addStaticInfo("Server = " + application.getServerInfo());
        }
        catch (IOException e) {
            throw new ServletException("Exception while loading lists in application manager: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ServletException("Exception while loading application manager " + appMgrClassname + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        Info.log("[Controller]", " callling destroy() ...");
        if (appManager != null) {
            appManager.destroy(appContext);
            Set<Filter> filters = appManager.getAllFilters();
            for (Filter f : filters) {
                f.destroy();
            }
        }
        super.destroy();
        if (JRubyInterpreter.isInitialized()) {
            JRubyInterpreter.getInstance().close();
        }
        LocaleManager.stopLocaleScan();
    }

    public static ServletContext getApplication() {
        return application;
    }

    protected String getURI(HttpServletRequest req) {
        int index;
        String context = req.getContextPath();
        String uri = req.getRequestURI().toString();
        if (context.length() > 0 && uri.indexOf(context) == 0) {
            uri = uri.substring(context.length());
        }
        if ((index = uri.lastIndexOf(".")) > 0) {
            uri = uri.substring(0, index);
        }
        if (uri.startsWith("/") && uri.length() > 1) {
            uri = uri.substring(1, uri.length());
        }
        return uri;
    }

    protected String getActionName(HttpServletRequest req) {
        String uri = this.getURI(req);
        int index = uri.lastIndexOf(".");
        if (index > 0 && uri.length() - index >= 2) {
            uri = uri.substring(0, index);
        }
        return uri;
    }

    protected String getInnerActionName(HttpServletRequest req) {
        String uri = this.getURI(req);
        String innerAction = null;
        int index = uri.lastIndexOf(".");
        if (index > 0 && uri.length() - index >= 2) {
            innerAction = uri.substring(index + 1, uri.length());
        }
        return innerAction;
    }

    protected void prepareAction(Action action, HttpServletRequest req, HttpServletResponse res) {
        action.setInput(new RequestInput(req));
        action.setOutput(new ResponseOutput(res));
        action.setSession(new SessionContext(req, res));
        action.setApplication(appContext);
        action.setCookies(new CookieContext(req, res));
        action.setLocale(LocaleManager.getLocale(req));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session;
        StickyActionMap map;
        String hostname;
        if (appManager == null) {
            throw new ServletException("The Application manager is not loaded");
        }
        res.setHeader("Mentawai-Version", "2.2.2");
        if (reloadAppManager) {
            Controller controller = this;
            synchronized (controller) {
                if (Controller.isAppMgrModified()) {
                    if (Debug.isEnabled()) {
                        Debug.log("Controller", "Re-loading modified application manager!");
                    }
                    if (appManager != null) {
                        this.destroy();
                    }
                    Controller.initApplicationManager();
                }
            }
        }
        if (appManager.getReqCharEncoding() != null) {
            try {
                req.setCharacterEncoding(appManager.getReqCharEncoding());
            }
            catch (Exception e) {
                throw new ServletException("The encoding set by setReqCharEncoding is not supported: " + appManager.getReqCharEncoding());
            }
        }
        appManager.service(appContext, req, res);
        String actionName = this.getActionName(req);
        if (statsMode && actionName.equalsIgnoreCase(ApplicationManagerViewer.STATS_PAGE_NAME)) {
            ApplicationManagerViewer applicationManagerViewer = new ApplicationManagerViewer();
            applicationManagerViewer.buildApplicationManagerStats(res);
            return;
        }
        String innerAction = this.getInnerActionName(req);
        ActionConfig ac = null;
        if (innerAction != null) {
            ac = appManager.getActionConfig(actionName, innerAction);
        }
        if (ac == null) {
            ac = appManager.getActionConfig(actionName);
        }
        if (ac == null) {
            if (ApplicationManager.getDefaultAction() != null) {
                ac = ApplicationManager.getDefaultAction();
            } else {
                throw new ServletException("Could not find action for actionName: " + actionName + (innerAction != null ? "." + innerAction : ""));
            }
        }
        if (ac.isInternalOnly() && !(hostname = req.getRemoteHost()).equalsIgnoreCase("localhost") && !hostname.equals("127.0.0.1")) {
            throw new ServletException("Action is internal so you cannot call it from here: " + hostname);
        }
        Action action = null;
        Class<? extends Object> actionClass = ac.getActionClass();
        if (StickyAction.class.isAssignableFrom(actionClass) && (map = (StickyActionMap)(session = req.getSession(true)).getAttribute(STICKY_KEY)) != null) {
            action = map.get(actionClass);
        }
        if (action == null) {
            action = ac.getAction();
        }
        if (action == null) {
            throw new ServletException("Could not get an action instace: " + ac);
        }
        this.prepareAction(action, req, res);
        StringBuffer sb = null;
        long now = 0L;
        if (debugMode) {
            sb = new StringBuffer(2048);
            DebugServletFilter.debug(sb, actionName, innerAction, ac, req.getLocale(), action.getLocale());
            action.getOutput().setValue(DebugServletFilter.DEBUG_KEY, sb);
            now = System.currentTimeMillis();
        }
        ArrayList<Filter> filters = new ArrayList<Filter>(32);
        Consequence c = null;
        boolean conseqExecuted = false;
        boolean actionExecuted = false;
        StringBuilder returnedResult = new StringBuilder(32);
        try {
            c = Controller.invokeAction(ac, action, innerAction, filters, returnedResult);
            actionExecuted = true;
            if (debugMode) {
                DebugServletFilter.debug(sb, c);
                if (c instanceof Redirect) {
                    action.getSession().setAttribute(DebugServletFilter.DEBUG_KEY, sb);
                }
                long time = System.currentTimeMillis() - now;
                DebugServletFilter.debug(sb, time);
            }
            res.setHeader("Mentawai-Result", returnedResult.toString());
            c.execute(action, returnedResult.toString(), req, res);
            conseqExecuted = true;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Throwable cause = this.getRootCause(e);
                throw new ServletException("Exception while invoking action " + actionName + ": " + e.getMessage() + " / " + e.getClass().getName() + " / " + cause.getMessage() + " / " + cause.getClass().getName(), cause);
            }
            catch (Throwable throwable) {
                for (int i = filters.size() - 1; i >= 0; --i) {
                    Filter f = (Filter)filters.get(i);
                    if (f instanceof AfterConsequenceFilter) {
                        AfterConsequenceFilter acf = (AfterConsequenceFilter)f;
                        try {
                            String s = returnedResult.toString();
                            acf.afterConsequence(action, c, conseqExecuted, actionExecuted, s.length() > 0 ? s : null);
                        }
                        catch (Exception e2) {
                            throw new ServletException("Exception while executing the AfterConsequence filters: " + e2.getMessage(), (Throwable)e2);
                        }
                    }
                    if (!(f instanceof InputWrapper)) continue;
                    InputWrapper iw = (InputWrapper)((Object)f);
                    iw.removeInput();
                }
                throw throwable;
            }
        }
        for (int i = filters.size() - 1; i >= 0; --i) {
            Filter f = (Filter)filters.get(i);
            if (f instanceof AfterConsequenceFilter) {
                AfterConsequenceFilter acf = (AfterConsequenceFilter)f;
                try {
                    String s = returnedResult.toString();
                    acf.afterConsequence(action, c, conseqExecuted, actionExecuted, s.length() > 0 ? s : null);
                }
                catch (Exception e) {
                    throw new ServletException("Exception while executing the AfterConsequence filters: " + e.getMessage(), (Throwable)e);
                }
            }
            if (!(f instanceof InputWrapper)) continue;
            InputWrapper iw = (InputWrapper)((Object)f);
            iw.removeInput();
        }
    }

    private Throwable getRootCause(Throwable t) {
        Throwable curr = t;
        while (curr.getCause() != null) {
            curr = curr.getCause();
        }
        return curr;
    }

    public static Consequence invokeAction(ActionConfig ac, Action action, String innerAction, List<Filter> filters, StringBuilder returnedResult) throws Exception {
        InvocationChain chain = Controller.createInvocationChain(ac, action, innerAction);
        if (filters == null || filters.size() != 0) {
            throw new IllegalArgumentException("filters parameter should be non-null and a zero-sized list!");
        }
        Iterator<Filter> iter = chain.getFilters().iterator();
        while (iter.hasNext()) {
            filters.add(iter.next());
        }
        String result = chain.invoke();
        returnedResult.append(result);
        if (debugMode) {
            DebugServletFilter.debugInputOutput(action);
            StringBuffer sb = DebugServletFilter.getDebug(action);
            DebugServletFilter.debug(sb, result, true);
        }
        Consequence c = null;
        if (innerAction != null) {
            c = ac.getConsequence(result, innerAction);
        }
        if (c == null) {
            c = ac.getConsequence(result);
        }
        if (c == null) {
            c = appManager.getGlobalConsequence(result);
        }
        if (c == null) {
            c = ac.getCatchAll();
        }
        if (consequenceProvider != null) {
            if (c == null && (c = consequenceProvider.getConsequence(ac.getName(), ac.getActionClass(), result, innerAction)) != null) {
                if (innerAction != null && ac.getInnerAction() == null) {
                    ac.addConsequence(result, innerAction, c);
                } else {
                    ac.addConsequence(result, c);
                }
            }
        } else if (c == null && autoView) {
            c = defaultConsequenceProvider.getConsequence(ac.getName(), ac.getActionClass(), result, innerAction);
        }
        if (c == null) {
            throw new ActionException("Action has no consequence for result: " + ac.getName() + " / innerAction = " + (innerAction != null ? innerAction : "NULL") + " - " + result);
        }
        return c;
    }

    private static boolean hasGlobalFilterFreeMarkerFilter(List<Filter> filters, String innerAction) {
        for (Filter f : filters) {
            if (!GlobalFilterFreeMarkerFilter.class.isAssignableFrom(f.getClass())) continue;
            GlobalFilterFreeMarkerFilter gffmf = (GlobalFilterFreeMarkerFilter)f;
            return gffmf.isGlobalFilterFree(innerAction);
        }
        return false;
    }

    private static InvocationChain createInvocationChain(ActionConfig ac, Action action, String innerAction) {
        List<Filter> globals;
        List<Filter> klassFiltersLast;
        List<Filter> filters;
        List<Filter> klassFilters;
        List<Filter> globals2;
        InvocationChain chain = new InvocationChain(ac.getName(), action, ac);
        Object pojo = chain.getPojo();
        Object actionImpl = pojo != null ? pojo : action;
        List<Filter> firstFilters = ac.getFirstFilters(innerAction);
        if (firstFilters != null) {
            chain.addFilters(firstFilters);
        }
        boolean isGlobalFilterFree = false;
        if (actionImpl instanceof GlobalFilterFree) {
            GlobalFilterFree gff = (GlobalFilterFree)actionImpl;
            isGlobalFilterFree = gff.isGlobalFilterFree(innerAction);
        }
        if (!isGlobalFilterFree && (globals2 = appManager.getGlobalFilters(false)) != null) {
            chain.addFilters(globals2);
        }
        if ((klassFilters = appManager.getGlobalFilters(ac.getActionClass(), false)) != null) {
            chain.addFilters(klassFilters);
        }
        if ((filters = ac.getFilters(innerAction)) != null) {
            isGlobalFilterFree = Controller.hasGlobalFilterFreeMarkerFilter(filters, innerAction);
            if (isGlobalFilterFree) {
                chain.clearFilters();
                if (klassFilters != null) {
                    chain.addFilters(klassFilters);
                }
            }
            chain.addFilters(filters);
        }
        if ((klassFiltersLast = appManager.getGlobalFilters(ac.getActionClass(), true)) != null) {
            chain.addFilters(klassFiltersLast);
        }
        if (!isGlobalFilterFree && (globals = appManager.getGlobalFilters(true)) != null) {
            chain.addFilters(globals);
        }
        if (innerAction != null) {
            chain.setInnerAction(innerAction);
        }
        return chain;
    }

    static void adhere(StickyAction action, Class<? extends BaseAction> actionClass) {
        Context session = action.getSession();
        StickyActionMap map = (StickyActionMap)session.getAttribute(STICKY_KEY);
        if (map == null) {
            map = new StickyActionMap(new HashMap<Object, StickyAction>());
            session.setAttribute(STICKY_KEY, map);
        }
        map.put(actionClass, action);
    }

    static void disjoin(StickyAction action, Class<? extends BaseAction> actionClass) {
        Context session = action.getSession();
        StickyActionMap map = (StickyActionMap)session.getAttribute(STICKY_KEY);
        if (map != null) {
            map.remove(actionClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAppManager(ApplicationManager applicationManager) {
        ApplicationManager applicationManager2 = applicationManager;
        synchronized (applicationManager2) {
            appManager = applicationManager;
        }
    }

    private static class StickyActionMap
    implements HttpSessionBindingListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<Object, StickyAction> map;

        public StickyActionMap(Map<Object, StickyAction> map) {
            this.map = map;
        }

        public void put(Object key, StickyAction value) {
            this.map.put(key, value);
        }

        public StickyAction get(Object key) {
            return this.map.get(key);
        }

        public StickyAction remove(Object key) {
            return this.map.remove(key);
        }

        public void valueBound(HttpSessionBindingEvent evt) {
        }

        public void valueUnbound(HttpSessionBindingEvent evt) {
            for (StickyAction sticky : this.map.values()) {
                sticky.onRemoved();
            }
        }
    }
}

