/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.core.Action;
import org.mentawai.core.ActionConfig;
import org.mentawai.core.AfterConsequenceFilter;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Consequence;
import org.mentawai.core.ConsequenceException;
import org.mentawai.core.Controller;
import org.mentawai.core.Filter;
import org.mentawai.core.Input;
import org.mentawai.core.RequestInput;

public class Chain
implements Consequence {
    private ActionConfig ac;
    private String innerAction = null;
    private Class<? extends Object> actionClass;

    public Chain(ActionConfig ac) {
        this.ac = ac;
    }

    public Chain(ActionConfig ac, String innerAction) {
        this(ac);
        this.innerAction = innerAction;
    }

    public Chain(Class<? extends Object> klass, String innerAction) {
        this.actionClass = klass;
        this.innerAction = innerAction;
    }

    public Chain(Class<? extends Object> klass) {
        this.actionClass = klass;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(Action a, String result, HttpServletRequest req, HttpServletResponse res) throws ConsequenceException {
        int i;
        Action action;
        if (this.ac == null) {
            ActionConfig def = new ActionConfig(this.actionClass, this.innerAction);
            this.ac = ApplicationManager.getInstance().getActionConfig(def.getName(), def.getInnerAction());
            if (this.ac == null) {
                this.ac = def;
            }
        }
        if ((action = this.ac.getAction()) == null) {
            throw new ConsequenceException("Could not load action for chain: " + this.ac);
        }
        RequestInput input = new RequestInput(req);
        Input old = a.getInput();
        Iterator<String> iterOld = old.keys();
        while (iterOld.hasNext()) {
            String key = iterOld.next();
            input.setValue(key, old.getValue(key));
        }
        action.setInput(input);
        action.setOutput(a.getOutput());
        action.setSession(a.getSession());
        action.setApplication(a.getApplication());
        action.setLocale(a.getLocale());
        action.setCookies(a.getCookies());
        Consequence c = null;
        ArrayList<Filter> filters = new ArrayList<Filter>(32);
        boolean conseqExecuted = false;
        boolean actionExecuted = false;
        StringBuilder returnedResult = new StringBuilder(32);
        try {
            String innerAction = this.innerAction != null ? this.innerAction : this.ac.getInnerAction();
            c = Controller.invokeAction(this.ac, action, innerAction, filters, returnedResult);
            actionExecuted = true;
            c.execute(action, returnedResult.toString(), req, res);
            conseqExecuted = true;
            i = filters.size() - 1;
        }
        catch (ConsequenceException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new ConsequenceException(e2);
                }
            }
            catch (Throwable throwable) {
                int i2 = filters.size() - 1;
                while (true) {
                    if (i2 < 0) {
                        throw throwable;
                    }
                    Filter f = (Filter)filters.get(i2);
                    if (f instanceof AfterConsequenceFilter) {
                        AfterConsequenceFilter acf = (AfterConsequenceFilter)f;
                        try {
                            String s = returnedResult.toString();
                            acf.afterConsequence(action, c, conseqExecuted, actionExecuted, s.length() > 0 ? s : null);
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                        }
                    }
                    --i2;
                }
            }
        }
        while (i >= 0) {
            Filter f = (Filter)filters.get(i);
            if (f instanceof AfterConsequenceFilter) {
                AfterConsequenceFilter acf = (AfterConsequenceFilter)f;
                try {
                    String s = returnedResult.toString();
                    acf.afterConsequence(action, c, conseqExecuted, actionExecuted, s.length() > 0 ? s : null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            --i;
        }
        return;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("Chain to ").append(this.ac);
        if (this.innerAction != null) {
            sb.append(" (innerAction = ").append(this.innerAction).append(")");
        }
        return sb.toString();
    }
}

