/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.io.IOException;
import org.mentawai.core.Context;
import org.mentawai.core.DSLException;
import org.mentawai.core.ScriptApplicationManager;

public class BshApplicationManager
extends ScriptApplicationManager {
    public static final String DEFAULT_SCRIPT_NAME = "ApplicationManager.bsh";
    public static final String METHOD_NAME = "config(appMgr, application)";

    @Override
    public void init(Context application) {
        this.runScript(application);
    }

    @Override
    protected String getScriptName() {
        return DEFAULT_SCRIPT_NAME;
    }

    protected void prepareScript(Interpreter i) throws EvalError {
        i.set("SUCCESS", (Object)"success");
        i.set("ERROR", (Object)"error");
        i.set("LOGIN", (Object)"login");
        i.set("ACCESSDENIED", (Object)"accessdenied");
        i.set("ACTION", 10);
        i.set("REQUEST", 11);
        i.set("INPUT", 1);
        i.set("OUTPUT", 2);
        i.set("SESSION", 3);
        i.set("APPLICATION", 4);
        i.set("EXCEPTION", (Object)EXCEPTION);
        i.set("REDIR", (Object)"redir");
        i.eval("fwd(a) { return new Forward(a); }");
        i.eval("redir(a) { return new Redirect(a); }");
    }

    @Override
    public void runScript(String scriptFile, Context application) {
        try {
            Interpreter i = new Interpreter();
            i.source(scriptFile);
            i.set("application", (Object)application);
            i.set("appMgr", (Object)this);
            this.prepareScript(i);
            i.eval(METHOD_NAME);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DSLException("Error reading the bsh script " + scriptFile);
        }
        catch (TargetError e) {
            e.printStackTrace();
            throw new DSLException("Error executing the bsh script " + scriptFile + ": " + e.getTarget());
        }
        catch (EvalError e) {
            e.printStackTrace();
            throw new DSLException("Error validating the bsh script " + scriptFile);
        }
    }
}

