/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.mentawai.action.BaseLoginAction;
import org.mentawai.ajax.AjaxConsequence;
import org.mentawai.core.Action;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Context;
import org.mentawai.core.Controller;
import org.mentawai.core.Input;
import org.mentawai.core.MapContext;
import org.mentawai.core.MapInput;
import org.mentawai.core.MapOutput;
import org.mentawai.core.Output;
import org.mentawai.core.StickyAction;
import org.mentawai.filter.TransactionFilter;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.message.ClassMessageContext;
import org.mentawai.message.DefaultMessage;
import org.mentawai.message.FileMessageContext;
import org.mentawai.message.Message;
import org.mentawai.message.MessageContext;
import org.mentawai.message.MessageManager;
import org.mentawai.transaction.Transaction;
import org.mentawai.validation.Validator;

public abstract class BaseAction
implements StickyAction {
    private static MessageContext FIXED_MSG_CONTEXT = null;
    protected MessageContext msgContext;
    protected Input input;
    protected Output output;
    protected Context session;
    protected Context application;
    protected Context cookies;
    protected Locale loc;

    public BaseAction() {
        if (LocaleManager.isUseMasterForEverything()) {
            this.msgContext = new FileMessageContext(LocaleManager.getMaster(), "");
            if (LocaleManager.isUsePrefixForActions()) {
                FileMessageContext fmc = (FileMessageContext)this.msgContext;
                String prefix = this.getClass().getSimpleName();
                fmc.setPrefix(prefix);
            }
        } else {
            this.msgContext = FIXED_MSG_CONTEXT != null ? FIXED_MSG_CONTEXT : new ClassMessageContext(this.getClass());
        }
    }

    public static void init(Action action) {
        action.setInput(new MapInput());
        action.setOutput(new MapOutput());
        action.setSession(new MapContext());
        Context application = ApplicationManager.getApplication();
        if (application != null) {
            action.setApplication(application);
        } else {
            action.setApplication(new MapContext());
        }
        action.setCookies(new MapContext());
        action.setLocale(Locale.getDefault());
    }

    public void init() {
        BaseAction.init(this);
    }

    public boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public void commit() throws Exception {
        this.commit(TransactionFilter.TRANSACTION_KEY);
    }

    public void commit(String trans) throws Exception {
        Object obj;
        if (this.input.hasValue(trans) && (obj = this.input.getValue(trans)) instanceof Transaction) {
            Transaction t = (Transaction)obj;
            t.commit();
        }
    }

    public void rollback() throws Exception {
        this.rollback(TransactionFilter.TRANSACTION_KEY);
    }

    public void rollback(String trans) throws Exception {
        Object obj;
        if (this.input.hasValue(trans) && (obj = this.input.getValue(trans)) instanceof Transaction) {
            Transaction t = (Transaction)obj;
            t.rollback();
        }
    }

    public boolean isPost() {
        return BaseAction.isPost(this);
    }

    public boolean isGet() {
        return BaseAction.isGet(this);
    }

    public static boolean isPost(Action action) {
        Input input = action.getInput();
        String method = input.getProperty("method");
        boolean isPost = method != null && method.equalsIgnoreCase("post");
        return isPost;
    }

    public static boolean isGet(Action action) {
        Input input = action.getInput();
        String method = input.getProperty("method");
        boolean isGet = method != null && method.equalsIgnoreCase("get");
        return isGet;
    }

    public static void setMessageContext(MessageContext msgContext) {
        FIXED_MSG_CONTEXT = msgContext;
    }

    protected boolean hasError() {
        return this.getErrors().size() > 0 || this.getFieldErrors().size() > 0;
    }

    private List<Message> getMessages() {
        return MessageManager.getMessages(this, true);
    }

    private List<Message> getMessages(boolean flash) {
        return MessageManager.getMessages(this, true, flash);
    }

    private List<Message> getErrors() {
        return MessageManager.getErrors(this, true);
    }

    private Map<String, Message> getFieldErrors() {
        return MessageManager.getFieldErrors(this, true);
    }

    public static Map<String, String> getMessageTokens(Action action, String field) {
        Object value;
        String key;
        Input input = action.getInput();
        Output output = action.getOutput();
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<String> iter = input.keys();
        while (iter.hasNext()) {
            key = iter.next();
            value = input.getString(key);
            map.put(key, (String)value);
        }
        if (field != null) {
            map.put(Validator.FIELD_TOKEN, input.getString(field));
        }
        iter = output.keys();
        while (iter.hasNext()) {
            key = iter.next();
            value = output.getValue(key);
            if (value == null) continue;
            map.put(key, value.toString());
        }
        return map;
    }

    protected Map<String, String> getMessageTokens(String field) {
        return BaseAction.getMessageTokens(this, field);
    }

    public void addMessage(String msg_id) {
        this.addMessage(msg_id, false);
    }

    public void addMessage(String msg_id, boolean flash) {
        List<Message> messages = this.getMessages(flash);
        messages.add(new DefaultMessage(msg_id, this.msgContext, this.getMessageTokens(null)));
    }

    public void addMessage(String msg_id, Map<String, String> tokens) {
        this.addMessage(msg_id, tokens, false);
    }

    public void addMessage(String msg_id, Map<String, String> tokens, boolean flash) {
        List<Message> messages = this.getMessages(flash);
        messages.add(new DefaultMessage(msg_id, this.msgContext, tokens));
    }

    public void addMessage(int msg_id) {
        this.addMessage(msg_id, false);
    }

    public void addMessage(int msg_id, boolean flash) {
        this.addMessage(String.valueOf(msg_id), flash);
    }

    public void addError(String error_id) {
        List<Message> errors = this.getErrors();
        errors.add(new DefaultMessage(error_id, this.msgContext, this.getMessageTokens(null)));
    }

    public void addError(String error_id, Map<String, String> tokens) {
        List<Message> errors = this.getErrors();
        errors.add(new DefaultMessage(error_id, this.msgContext, tokens));
    }

    public void addError(int error_id) {
        this.addError(String.valueOf(error_id));
    }

    public void addError(String field, String error_id) {
        Map<String, Message> fieldErrors = this.getFieldErrors();
        fieldErrors.put(field, new DefaultMessage(error_id, this.msgContext, this.getMessageTokens(field)));
    }

    public String getError(String field) {
        Map<String, Message> fieldErrors = this.getFieldErrors();
        Message m = fieldErrors.get(field);
        if (m != null) {
            return m.getId();
        }
        return null;
    }

    public void addError(String field, String error_id, Map<String, String> tokens) {
        Map<String, Message> fieldErrors = this.getFieldErrors();
        fieldErrors.put(field, new DefaultMessage(error_id, this.msgContext, tokens));
    }

    public void addError(String field, int error_id) {
        this.addError(field, String.valueOf(error_id));
    }

    public void addMessage(String msg_id, MessageContext msgContext) {
        this.addMessage(msg_id, msgContext, false);
    }

    public void addMessage(String msg_id, MessageContext msgContext, boolean flash) {
        List<Message> messages = this.getMessages(flash);
        messages.add(new DefaultMessage(msg_id, msgContext, this.getMessageTokens(null)));
    }

    public void addMessage(int msg_id, MessageContext msgContext) {
        this.addMessage(msg_id, msgContext, false);
    }

    public void addMessage(int msg_id, MessageContext msgContext, boolean flash) {
        this.addMessage(String.valueOf(msg_id), msgContext, flash);
    }

    public void addError(String error_id, MessageContext msgContext) {
        List<Message> errors = this.getErrors();
        errors.add(new DefaultMessage(error_id, msgContext, this.getMessageTokens(null)));
    }

    public void addError(int error_id, MessageContext msgContext) {
        this.addError(String.valueOf(error_id), msgContext);
    }

    public void addError(String field, String error_id, MessageContext msgContext) {
        Map<String, Message> fieldErrors = this.getFieldErrors();
        fieldErrors.put(field, new DefaultMessage(error_id, msgContext, this.getMessageTokens(field)));
    }

    public void addError(String field, int error_id, MessageContext msgContext) {
        this.addError(field, String.valueOf(error_id), msgContext);
    }

    public void addMessage(Message msg) {
        this.addMessage(msg, false);
    }

    public void addMessage(Message msg, boolean flash) {
        List<Message> messages = this.getMessages(flash);
        messages.add(msg);
    }

    public void addError(Message error) {
        List<Message> errors = this.getErrors();
        errors.add(error);
    }

    public void addError(String field, Message error) {
        Map<String, Message> fieldErrors = this.getFieldErrors();
        fieldErrors.put(field, error);
    }

    @Override
    public void setInput(Input input) {
        this.input = input;
    }

    @Override
    public void setOutput(Output output) {
        this.output = output;
    }

    @Override
    public void setSession(Context context) {
        this.session = context;
    }

    @Override
    public void setApplication(Context context) {
        this.application = context;
    }

    @Override
    public void setCookies(Context context) {
        this.cookies = context;
    }

    @Override
    public void setLocale(Locale loc) {
        this.loc = loc;
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public Context getSession() {
        return this.session;
    }

    @Override
    public Context getApplication() {
        return this.application;
    }

    @Override
    public Context getCookies() {
        return this.cookies;
    }

    @Override
    public Locale getLocale() {
        return this.loc;
    }

    public <E> E getSessionObj() {
        return (E)BaseLoginAction.getSessionObj(this.session);
    }

    public <E> E getUserSession() {
        return (E)BaseLoginAction.getUserSession(this.session);
    }

    public Locale getUserLocale() {
        return BaseLoginAction.getUserLocale(this.session);
    }

    public boolean isLogged() {
        return BaseLoginAction.isLogged(this.session);
    }

    @Override
    public void adhere() {
        Controller.adhere(this, this.getClass());
    }

    @Override
    public void disjoin() {
        Controller.disjoin(this, this.getClass());
    }

    @Override
    public void onRemoved() {
    }

    public String execute() throws Exception {
        return "success";
    }

    public void ajax(Object value) {
        this.output.setValue(AjaxConsequence.OBJECT, value);
    }

    public void stream(Object value) {
        this.output.setValue("stream", value);
    }

    public void stream(Object value, int length) {
        this.output.setValue("contentLength", length);
        this.stream(value);
    }

    public void redir(String url) {
        this.output.setValue("_mentawai_redirect_url", url);
    }

    public String getContextPath() {
        return this.input.getProperty("contextPath");
    }

    public Input input() {
        return this.getInput();
    }

    public Output output() {
        return this.getOutput();
    }

    public Context session() {
        return this.getSession();
    }

    public Context application() {
        return this.getApplication();
    }

    public Context cookies() {
        return this.getCookies();
    }

    public Locale loc() {
        return this.getLocale();
    }

    public static Object findValue(String key, Action action) {
        Object value = null;
        Input input = action.getInput();
        value = input.getValue(key);
        if (value != null) {
            return value;
        }
        Output output = action.getOutput();
        value = output.getValue(key);
        if (value != null) {
            return value;
        }
        Context session = action.getSession();
        value = session.getAttribute(key);
        if (value != null) {
            return value;
        }
        Context application = action.getApplication();
        value = application.getAttribute(key);
        if (value != null) {
            return value;
        }
        return null;
    }

    public Object findValue(String key) {
        return BaseAction.findValue(key, this);
    }

    public void setSessionObj(Object user) {
        this.setUserSession(user);
    }

    public void setSessionUser(Object user) {
        this.setUserSession(user);
    }

    public void setSessionGroup(Enum<?> e) {
        this.setSessionGroup(e.toString());
    }

    public void setSessionGroups(Enum<?> ... es) {
        String[] s = new String[es.length];
        int index = 0;
        for (Enum<?> e : es) {
            s[index++] = e.toString();
        }
        this.setSessionGroups(s);
    }

    public void setSessionGroup(String group) {
        this.setSessionGroups(group);
    }

    public void setSessionGroups(String ... groups) {
        BaseLoginAction.setUserGroups(this.session, groups);
    }

    public Locale getSessionLocale() {
        return this.getUserLocale();
    }

    public void setSessionLocale(Locale loc) {
        BaseLoginAction.setSessionLocale(loc, this.session);
    }

    public void setSessionLocale(String locale) {
        BaseLoginAction.setUserLocale(locale, this.session);
    }

    public void setUserSession(Object user) {
        BaseLoginAction.setUserSession(user, this.session);
    }

    public void replaceSessionObj(Object newUser) {
        this.replaceUserSession(newUser);
    }

    public void replaceUserSession(Object newUser) {
        BaseLoginAction.replaceUserSession(newUser, this.session);
    }
}

