/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.core.ActionConfig;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Filter;

public class ApplicationManagerViewer {
    public static String STATS_PAGE_NAME = "stats";
    private String STATS_VERSION = "1.1";
    private ApplicationManager applicationManager = ApplicationManager.getInstance();

    public void buildApplicationManagerStats(HttpServletResponse res) throws IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        Set<Filter> allFilters = this.applicationManager.getAllFilters();
        List<Filter> allGlobalFilters = this.applicationManager.getGlobalFilters();
        Map<String, ActionConfig> actions = this.applicationManager.getActions();
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        out.println("<head>");
        out.println("\t<meta http-equiv=\"content-type\" content=\"text/html; charset=iso-8859-1\"/>");
        out.println("\t<title>ApplicationManager Statistics " + this.STATS_VERSION + "</title>");
        out.println("\t<link rel=\"stylesheet\" href=\"dyntags/stats/jquery.css\" />");
        out.println("\t<link rel=\"stylesheet\" href=\"dyntags/stats/screen.css\" />");
        out.println("\t<script src=\"dyntags/stats/jquery.js\" type=\"text/javascript\"></script>");
        out.println("\t<script src=\"dyntags/stats/jquery_treeview.js\" type=\"text/javascript\"></script>");
        out.println("\t<script type=\"text/javascript\">");
        out.println("\t$(document).ready(function(){");
        out.println("\t\t$(\"#browser\").treeview({");
        out.println("\t\t\ttoggle: function() {");
        out.println("\t\t\t\tconsole.log(\"%s was toggled.\", $(this).find(\">span\").text());");
        out.println("\t\t\t}");
        out.println("\t\t});");
        out.println("\t});");
        out.println("\t</script>");
        out.println("\t</head>");
        out.println("\t<body>");
        out.println("\t<h1 id=\"banner\">Mentawai Web Framework 2.2.2 Build:20111018</h1>");
        out.println("\t<div id=\"main\">");
        out.println("\t<b>ApplicationManager Statistics " + this.STATS_VERSION + "</b>");
        out.println("\t<ul id=\"browser\" class=\"filetree treeview-famfamfam\">");
        out.println("\t\t<li><span class=\"folder\">Filters [" + this.applicationManager.getAllFilters().size() + "]</span>");
        out.println("\t\t\t<ul>");
        for (Filter filter : allFilters) {
            out.println("<li><span class=\"file\">" + filter + "</span></li>");
        }
        out.println("\t\t\t</ul>");
        out.println("\t\t</li>");
        out.println("\t\t<li><span class=\"folder\">Global Filters [" + this.applicationManager.getGlobalFilters().size() + "]</span>");
        out.println("\t\t\t<ul>");
        for (Filter filter : allGlobalFilters) {
            out.println("<li><span class=\"file\">" + filter + "</span></li>");
        }
        out.println("\t\t\t</ul>");
        out.println("\t\t</li>");
        out.println("\t\t<li><span class=\"folder\">Actions [" + this.applicationManager.getActions().size() + "]</span>");
        out.println("\t\t\t<ul>");
        for (String action : actions.keySet()) {
            out.println("<li><span class=\"file\">" + action + "</span></li>");
        }
        out.println("\t        </ul>");
        out.println("\t\t</li>");
        out.println("\t</ul>");
        out.println("</div>");
        out.println("</body></html>");
    }
}

