/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mentabean.BeanConfig;
import org.mentabean.BeanManager;
import org.mentacontainer.Container;
import org.mentacontainer.Factory;
import org.mentacontainer.Scope;
import org.mentacontainer.impl.MentaContainer;
import org.mentacontainer.impl.WrapperFactory;
import org.mentawai.ajax.AjaxConsequence;
import org.mentawai.ajax.AjaxRenderer;
import org.mentawai.coc.ConsequenceProvider;
import org.mentawai.core.Action;
import org.mentawai.core.ActionConfig;
import org.mentawai.core.BaseAction;
import org.mentawai.core.Chain;
import org.mentawai.core.Configurable;
import org.mentawai.core.Consequence;
import org.mentawai.core.Context;
import org.mentawai.core.Controller;
import org.mentawai.core.ExceptionConsequence;
import org.mentawai.core.Filter;
import org.mentawai.core.Forward;
import org.mentawai.core.Props;
import org.mentawai.core.Redirect;
import org.mentawai.core.ResultConsequence;
import org.mentawai.core.StreamConsequence;
import org.mentawai.core.StringConsequence;
import org.mentawai.db.ConnectionHandler;
import org.mentawai.filter.ExceptionFilter;
import org.mentawai.filter.InjectionFilter;
import org.mentawai.filter.OutjectionFilter;
import org.mentawai.filter.OutputFilter;
import org.mentawai.formatter.DateFormatter;
import org.mentawai.formatter.FormatterManager;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.ioc.Bean;
import org.mentawai.ioc.DefaultComponent;
import org.mentawai.ioc.Dependency;
import org.mentawai.ioc.ScopeComponent;
import org.mentawai.jruby.RubyActionConfig;
import org.mentawai.list.DBListData;
import org.mentawai.list.ListData;
import org.mentawai.list.ListManager;
import org.mentawai.spring.SpringActionConfig;
import org.mentawai.util.DebugServletFilter;
import org.mentawai.util.SystemUtils;

public abstract class ApplicationManager {
    public static final String SUCCESS = "success";
    public static final String ERROR = "error";
    public static final String SHOW = "show";
    public static final String LIST = "list";
    public static final String INDEX = "index";
    public static final String MAIN = "main";
    public static final String LOGIN = "login";
    public static final String ACCESSDENIED = "accessdenied";
    public static final String TEST = "test";
    public static final String JSP = "jsp";
    public static final String CREATED = "created";
    public static final String UPDATED = "updated";
    public static final String REMOVED = "removed";
    public static final String ALREADY = "already";
    public static final String BLOCKED = "blocked";
    public static final String XML = "xml";
    public static final String JSON = "json";
    public static final String HTML = "html";
    public static final String ADD = "add";
    public static final String EDIT = "edit";
    public static final String NEXT = "next";
    public static final String BACK = "back";
    public static final String AJAX = "ajax";
    public static final String STREAM = "stream";
    public static final int ACTION = 10;
    public static final int REQUEST = 11;
    public static final int INPUT = 1;
    public static final int OUTPUT = 2;
    public static final int SESSION = 3;
    public static final int APPLICATION = 4;
    public static final String EXCEPTION = ExceptionFilter.EXCEPTION;
    public static final String REDIR = "redir";
    public static final String MENTAWAI_VERSION = "2.2.2";
    public static final String MENTAWAI_BUILD = "20111018";
    public static String EXTENSION = "mtw";
    public static String CONTEXT_PATH = null;
    public static int PORT = 80;
    private static String REALPATH;
    private Map<String, ActionConfig> actions = new HashMap<String, ActionConfig>();
    private Map<String, Map<String, ActionConfig>> innerActions = new HashMap<String, Map<String, ActionConfig>>();
    private List<Filter> globalFilters = new LinkedList<Filter>();
    private List<Filter> globalFiltersLast = new LinkedList<Filter>();
    private Map<String, Consequence> globalConsequences = new HashMap<String, Consequence>();
    private Map<String, Bean> components = new HashMap<String, Bean>();
    private Set<Dependency> dependencies = new HashSet<Dependency>();
    private Map<Class<? extends Object>, List<Filter>> klassGlobalFilters = new HashMap<Class<? extends Object>, List<Filter>>();
    private Map<Class<? extends Object>, List<Filter>> klassGlobalFiltersLast = new HashMap<Class<? extends Object>, List<Filter>>();
    static ApplicationManager instance;
    private String reqCharEncoding = null;
    private static String viewDir;
    private final BeanManager beanManager = new BeanManager();
    private static ActionConfig defaultAction;
    private static Context appContext;
    protected static Container container;
    static boolean removeActionFromName;
    private boolean autowireEverything = true;
    private ApplicationManager parent;
    private volatile Environment environment = null;
    private List<String> actionPackages = new LinkedList<String>();

    public void setEnvironment(Environment env) {
        this.environment = env;
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            String envString = SystemUtils.getString("env");
            if (envString == null) {
                envString = SystemUtils.getString("ENV");
            }
            this.environment = envString == null ? Environment.DEV : Environment.valueOf(envString.toUpperCase());
        }
        return this.environment;
    }

    public static void setRemoveActionFromName(boolean flag) {
        removeActionFromName = flag;
    }

    static void setApplication(Context appContext) {
        ApplicationManager.appContext = appContext;
    }

    public static Context getApplication() {
        return appContext;
    }

    public static ApplicationManager getInstance() {
        return instance;
    }

    public static void setRealPath(String realpath) {
        REALPATH = realpath;
    }

    public void setAutowireEverything(boolean flag) {
        this.autowireEverything = flag;
    }

    public void setReqCharEncoding(String encoding) {
        this.reqCharEncoding = encoding;
    }

    public String getReqCharEncoding() {
        return this.reqCharEncoding;
    }

    private String findHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getContextPath() {
        return CONTEXT_PATH;
    }

    public static void setDefaultAction(ActionConfig ac) {
        defaultAction = ac;
    }

    public static ActionConfig getDefaultAction() {
        return defaultAction;
    }

    public Props getProperties() {
        if (REALPATH == null) {
            throw new IllegalStateException("Realpath is not set for this application!");
        }
        String hostname = this.findHostName();
        File fileWithHostname = null;
        if (hostname != null) {
            fileWithHostname = new File(REALPATH + File.separator + "WEB-INF" + File.separator + "appManager-" + hostname + ".properties");
        }
        File file = new File(REALPATH + File.separator + "WEB-INF" + File.separator + "appManager.properties");
        if (fileWithHostname != null && fileWithHostname.exists()) {
            Props props = new Props();
            try {
                props.load(new FileInputStream(fileWithHostname));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return props;
        }
        if (file.exists()) {
            Props props = new Props();
            try {
                props.load(new FileInputStream(file));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return props;
        }
        throw new RuntimeException("Cannot find appManager.properties or appManager-HOSTNAME.properties inside WEB-INF!");
    }

    public Props getProps() {
        return this.getProps(this.getEnvironment().toString().toLowerCase());
    }

    public Props getProps(String env) {
        if (REALPATH == null) {
            throw new IllegalStateException("Realpath is not set for this application!");
        }
        File def = new File(REALPATH + File.separator + "WEB-INF" + File.separator + "conf" + File.separator + "default" + File.separator + "appManager.properties");
        File file = null;
        if (env != null) {
            file = new File(REALPATH + File.separator + "WEB-INF" + File.separator + "conf" + File.separator + env + File.separator + "appManager.properties");
        }
        if (!(def.exists() || file != null && file.exists())) {
            throw new RuntimeException("Cannot find appManager.properties inside WEB-INF/conf!");
        }
        File local = null;
        if (env != null) {
            local = new File(REALPATH + File.separator + "WEB-INF" + File.separator + "conf" + File.separator + env + File.separator + "appManager-LOCAL.properties");
        }
        Props props = new Props();
        if (def.exists()) {
            try {
                props.loadDefault(new FileInputStream(def));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (file != null && file.exists()) {
            try {
                props.load(new FileInputStream(file));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (local != null && local.exists()) {
            try {
                props.loadLocal(new FileInputStream(local));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return props;
    }

    public StreamConsequence stream(String contentType) {
        return new StreamConsequence(contentType);
    }

    public StringConsequence string(String key) {
        return new StringConsequence(key);
    }

    public StringConsequence string() {
        return new StringConsequence();
    }

    public void addActionPackage(String actionPackage) {
        this.actionPackages.add(actionPackage);
    }

    public void removeActionPackage(String actionPackage) {
        this.actionPackages.remove(actionPackage);
    }

    public static void setViewDir(String viewDir) {
        ApplicationManager.viewDir = viewDir;
    }

    public static String getViewDir() {
        return viewDir;
    }

    public static String getRealPath() {
        return REALPATH;
    }

    public ApplicationManager() {
        instance = this;
        container = new MentaContainer();
    }

    public void setWebappPath(String s) {
        REALPATH = s;
    }

    public static Container getContainer() {
        return container;
    }

    public void reset() {
        this.actions.clear();
        this.innerActions.clear();
        this.globalFilters.clear();
        this.globalFiltersLast.clear();
        this.globalConsequences.clear();
    }

    void service(Context appContext, HttpServletRequest req, HttpServletResponse res) {
    }

    public ActionConfig addActionConfig(ActionConfig ac) {
        if (ac.getName() == null) {
            throw new IllegalStateException("Cannot add an action config without a name!");
        }
        String innerAction = ac.getInnerAction();
        if (innerAction == null) {
            this.actions.put(ac.getName(), ac);
        } else {
            Map<String, ActionConfig> map = this.innerActions.get(ac.getName());
            if (map == null) {
                map = new HashMap<String, ActionConfig>();
                this.innerActions.put(ac.getName(), map);
            }
            map.put(innerAction, ac);
        }
        return ac;
    }

    public BeanConfig addBeanConfig(BeanConfig bc) {
        this.beanManager.addBeanConfig(bc);
        return bc;
    }

    public BeanConfig getBeanConfig(Class<? extends Object> beanClass) {
        return this.beanManager.getBeanConfig(beanClass);
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public BeanConfig bean(Class<? extends Object> beanClass, String tableName) {
        return this.addBeanConfig(new BeanConfig(beanClass, tableName));
    }

    public boolean removeActionConfig(ActionConfig ac) {
        String name = ac.getName();
        if (name == null) {
            throw new IllegalStateException("Cannot remove an action config without a name!");
        }
        String innerAction = ac.getInnerAction();
        if (innerAction == null) {
            return this.actions.remove(name) != null;
        }
        Map<String, ActionConfig> map = this.innerActions.get(name);
        if (map != null) {
            return map.remove(innerAction) != null;
        }
        return false;
    }

    public ActionConfig add(ActionConfig ac) {
        return this.addActionConfig(ac);
    }

    public void init() {
        this.init(ApplicationManager.getApplication());
    }

    public void init(Context application) {
    }

    public void destroy(Context application) {
    }

    public void setupDB() {
    }

    public void loadFilters() {
    }

    public void setupIoC() {
    }

    public void loadBeans() {
    }

    public void loadActions() {
    }

    public void loadLocales() {
    }

    public void loadLists() throws Exception {
    }

    public void loadFormatters() {
    }

    public void onStarted(Context context) {
    }

    public void addLocale(String loc) {
        LocaleManager.add(loc);
    }

    public void addLocale(Locale loc) {
        LocaleManager.add(loc);
    }

    public ActionConfig getActionConfig(String name) {
        ActionConfig ac = this.actions.get(name);
        if (ac == null) {
            ac = this.loadActionConfig(name);
        }
        return ac;
    }

    protected Map<String, ActionConfig> getActions() {
        return this.actions;
    }

    public ActionConfig getActionConfig(String name, String innerAction) {
        if (innerAction == null) {
            return this.getActionConfig(name);
        }
        ActionConfig ac = null;
        Map<String, ActionConfig> map = this.innerActions.get(name);
        if (map != null) {
            ac = map.get(innerAction);
        }
        if (ac == null) {
            ac = this.loadActionConfig(name);
        }
        return ac;
    }

    private ActionConfig loadActionConfig(String name) {
        StringBuilder sb = new StringBuilder(32);
        for (String actionPackage : this.actionPackages) {
            sb.setLength(0);
            sb.append(actionPackage).append('.').append(name);
            Class<?> actionClass = null;
            try {
                actionClass = Class.forName(sb.toString());
            }
            catch (Exception e) {
                continue;
            }
            ActionConfig ac = new ActionConfig(actionClass);
            this.addActionConfig(ac);
            return ac;
        }
        return null;
    }

    public void addGlobalFilter(Filter filter) {
        this.addGlobalFilter(filter, false);
    }

    public void filter(Filter filter) {
        this.addGlobalFilter(filter);
    }

    public void addGlobalFilter(List filters) {
        this.addGlobalFilter(filters, false);
    }

    public void filter(List filters) {
        this.addGlobalFilter(filters);
    }

    public void addGlobalFilter(Filter filter, boolean last) {
        if (last) {
            this.globalFiltersLast.add(filter);
        } else if (filter.getClass().equals(InjectionFilter.class) || filter.getClass().equals(OutputFilter.class) || filter.getClass().equals(OutjectionFilter.class)) {
            if (filter instanceof OutputFilter) {
                OutputFilter outputFilter = (OutputFilter)filter;
                if (outputFilter.isNewVersion()) {
                    this.globalFilters.add(filter);
                } else {
                    this.globalFiltersLast.add(filter);
                }
            } else {
                this.globalFiltersLast.add(filter);
            }
        } else {
            this.globalFilters.add(filter);
        }
    }

    public void addGlobalFilter(Class<? extends Object> klass, Filter filter, boolean last) {
        if (last) {
            List<Filter> list = this.klassGlobalFiltersLast.get(klass);
            if (list != null) {
                list.add(filter);
            } else {
                list = new LinkedList<Filter>();
                list.add(filter);
                this.klassGlobalFiltersLast.put(klass, list);
            }
        } else {
            List<Filter> list = this.klassGlobalFilters.get(klass);
            if (list != null) {
                list.add(filter);
            } else {
                list = new LinkedList<Filter>();
                list.add(filter);
                this.klassGlobalFilters.put(klass, list);
            }
        }
    }

    public void filter(Class<? extends Object> klass, Filter filter) {
        this.addGlobalFilter(klass, filter, false);
    }

    public void filterLast(Class<? extends Object> klass, Filter filter) {
        this.addGlobalFilter(klass, filter, true);
    }

    public void filter(Filter filter, boolean last) {
        this.addGlobalFilter(filter, last);
    }

    public void filterLast(Filter filter) {
        this.addGlobalFilter(filter, true);
    }

    public void addGlobalFilter(List filters, boolean last) {
        for (Filter f : filters) {
            this.addGlobalFilter(f, last);
        }
    }

    public void filter(List filters, boolean last) {
        this.addGlobalFilter(filters, last);
    }

    public void filterLast(List filters) {
        this.addGlobalFilter(filters, true);
    }

    public void addGlobalConsequence(String result, Consequence c) {
        this.globalConsequences.put(result, c);
    }

    public void on(String result, Consequence c) {
        this.addGlobalConsequence(result, c);
    }

    public void on(String result, String jsp) {
        this.addGlobalConsequence(result, new Forward(jsp));
    }

    public List<Filter> getGlobalFilters(boolean last) {
        if (last) {
            return this.globalFiltersLast;
        }
        return this.globalFilters;
    }

    public List<Filter> getGlobalFilters(Class<? extends Object> klass, boolean last) {
        if (last) {
            return this.klassGlobalFiltersLast.get(klass);
        }
        return this.klassGlobalFilters.get(klass);
    }

    public List<Filter> getGlobalFilters() {
        LinkedList<Filter> list = new LinkedList<Filter>();
        list.addAll(this.getGlobalFilters(false));
        list.addAll(this.getGlobalFilters(true));
        return list;
    }

    public Consequence getGlobalConsequence(String result) {
        return this.globalConsequences.get(result);
    }

    Set<Filter> getAllFilters() {
        HashSet<Filter> filters = new HashSet<Filter>();
        filters.addAll(this.globalFilters);
        filters.addAll(this.globalFiltersLast);
        for (ActionConfig ac : this.actions.values()) {
            filters.addAll(ac.getFilters());
        }
        for (Map<String, ActionConfig> map : this.innerActions.values()) {
            for (ActionConfig ac : map.values()) {
                filters.addAll(ac.getFilters());
            }
        }
        return filters;
    }

    public static Consequence fwd(String page) {
        return new Forward(page);
    }

    public static Consequence redir(String page) {
        return new Redirect(page);
    }

    public static Consequence exception(String msg) {
        return new ExceptionConsequence(msg);
    }

    public static Consequence result() {
        return new ResultConsequence();
    }

    public static Consequence redir(ActionConfig ac) {
        return new Redirect(ac);
    }

    public static Consequence redir(Class<?> klass) {
        return ApplicationManager.redir(klass, null, false);
    }

    public static Consequence redir(Class<?> klass, boolean appendOutput) {
        return ApplicationManager.redir(klass, null, appendOutput);
    }

    public static Consequence redir(Class<?> klass, String innerAction) {
        return ApplicationManager.redir(klass, innerAction, false);
    }

    public static Consequence redir(Class<?> klass, String innerAction, boolean appendOutput) {
        StringBuilder page = new StringBuilder(klass.getSimpleName().length() + 4);
        page.append(klass.getSimpleName());
        if (innerAction != null) {
            page.append(".").append(innerAction);
        }
        page.append(".").append(EXTENSION);
        return new Redirect(page.toString(), appendOutput);
    }

    public static Consequence redir(String page, boolean flag) {
        return new Redirect(page, flag);
    }

    public static Consequence redir(ActionConfig ac, boolean flag) {
        return new Redirect(ac, flag);
    }

    public static Consequence redir() {
        return new Redirect();
    }

    public static Consequence redir(boolean flag) {
        return new Redirect(flag);
    }

    public static Consequence chain(ActionConfig ac) {
        return new Chain(ac);
    }

    public static Consequence ajax(AjaxRenderer renderer) {
        return new AjaxConsequence(renderer);
    }

    public static Consequence chain(ActionConfig ac, String innerAction) {
        return new Chain(ac, innerAction);
    }

    public static Consequence chain(Class<? extends Object> klass) {
        return new Chain(klass);
    }

    public static Consequence chain(Class<? extends Object> klass, String innerAction) {
        return new Chain(klass, innerAction);
    }

    public ActionConfig action(Class<? extends Object> klass) {
        return this.addActionConfig(new ActionConfig(klass));
    }

    public ActionConfig ruby(String klass) {
        return this.addActionConfig(new RubyActionConfig(klass));
    }

    public ActionConfig ruby(String name, String klass) {
        return this.addActionConfig(new RubyActionConfig(name, klass));
    }

    public ActionConfig ruby(String name, String klass, String innerAction) {
        return this.addActionConfig(new RubyActionConfig(name, klass, innerAction));
    }

    public ActionConfig spring(String path, String action) {
        return this.addActionConfig(new SpringActionConfig(path, action));
    }

    public ActionConfig spring(String path, String action, String innerAction) {
        return this.addActionConfig(new SpringActionConfig(path, action, innerAction));
    }

    public ActionConfig action(String name, Class<? extends Object> klass) {
        return this.addActionConfig(new ActionConfig(name, klass));
    }

    public ActionConfig internal(Class<? extends Object> klass, String innerAction) {
        ActionConfig ac = this.action(klass, innerAction);
        ac.catchAll(ApplicationManager.result()).internalOnly();
        return ac;
    }

    public ActionConfig action(String name, Class<? extends Object> klass, String innerAction) {
        return this.addActionConfig(new ActionConfig(name, klass, innerAction));
    }

    public ActionConfig action(Class<? extends Object> klass, String innerAction) {
        return this.addActionConfig(new ActionConfig(klass, innerAction));
    }

    public void setReloadable(boolean reloadable) {
        Controller.reloadAppManager = reloadable;
    }

    public void setDebugMode(boolean debugMode) {
        Controller.debugMode = debugMode;
    }

    public void setDebugMode(boolean debugMode, boolean commented) {
        Controller.debugMode = debugMode;
        DebugServletFilter.COMMENTED = commented;
    }

    public void setStatsMode(boolean statsMode) {
        Controller.statsMode = statsMode;
    }

    public void setReloadMode(boolean reloadMode) {
        Controller.reloadAppManager = reloadMode;
    }

    public Dependency autowire(String target, Class<? extends Object> klass, String source) {
        return this.addDependency(klass, target, source);
    }

    public Dependency autowire(String target, Class<? extends Object> klass) {
        return this.addDependency(klass, target, target);
    }

    public Dependency autowire(String sourceFromContainer) {
        container.autowire(sourceFromContainer);
        Class<? extends Object> klass = container.getType(sourceFromContainer);
        Dependency d = new Dependency(klass, sourceFromContainer, sourceFromContainer);
        this.dependencies.add(d);
        return d;
    }

    public Dependency addDependency(Class<? extends Object> klass, String target, String source) {
        container.autowire(source, target);
        Dependency d = new Dependency(klass, target, source);
        this.dependencies.add(d);
        return d;
    }

    public Dependency addDependency(Class<? extends Object> klass, String target) {
        return this.addDependency(klass, target, target);
    }

    public Dependency di(String target, Class<? extends Object> klass) {
        return this.addDependency(klass, target, target);
    }

    public Dependency di(String target, Class<? extends Object> klass, String source) {
        return this.addDependency(klass, target, source);
    }

    public Dependency autoWiring(String target, Class<? extends Object> klass) {
        return this.di(target, klass);
    }

    public Dependency aw(String target, Class<? extends Object> klass, String source) {
        return this.di(target, klass, source);
    }

    public Dependency aw(String target, Class<? extends Object> klass) {
        return this.di(target, klass);
    }

    public Dependency autoWiring(String target, Class<? extends Object> klass, String source) {
        return this.di(target, klass, source);
    }

    public Iterator<Dependency> getDependencies() {
        return this.dependencies.iterator();
    }

    public Map<String, Bean> getComponents() {
        return this.components;
    }

    public Set<String> getComponentNames() {
        return this.components.keySet();
    }

    public void setAutoView(boolean autoView) {
        Controller.autoView = autoView;
    }

    public Bean addComponent(String name, Bean comp) {
        ScopeComponent sc;
        if (comp == null) {
            return null;
        }
        Scope scope = Scope.THREAD;
        if (comp instanceof ScopeComponent && (sc = (ScopeComponent)comp).getScope() == 4) {
            scope = Scope.SINGLETON;
        }
        container.ioc(name, comp.getType(), scope);
        if (this.autowireEverything) {
            container.autowire(name);
        }
        this.components.put(name, comp);
        return comp;
    }

    public Bean add(String name, Bean comp) {
        this.addComponent(name, comp);
        return comp;
    }

    public Bean getComponent(String name) {
        return this.components.get(name);
    }

    public Bean ioc(String name, Bean comp) {
        this.addComponent(name, comp);
        return comp;
    }

    public void ioc(String name, Factory c) {
        this.ioc(name, c, Scope.THREAD);
    }

    public void ioc(String name, Object singleInstance) {
        WrapperFactory f = new WrapperFactory(singleInstance);
        this.ioc(name, f);
    }

    public void ioc(String name, Factory c, Scope s) {
        if (c != null) {
            container.ioc(name, c, s);
            if (this.autowireEverything) {
                container.autowire(name);
            }
        }
    }

    public DefaultComponent ioc(String name, Class<? extends Object> klass) {
        DefaultComponent c = new DefaultComponent(klass);
        this.addComponent(name, c);
        return c;
    }

    public ScopeComponent ioc(String name, Class klass, int scope) {
        ScopeComponent c = new ScopeComponent((Class<? extends Object>)klass, scope);
        this.addComponent(name, c);
        return c;
    }

    public void configureActions(String packageName) {
        try {
            List<Class> classes = ApplicationManager.getActionClasses(packageName);
            for (Class klass : classes) {
                if (!Configurable.class.isAssignableFrom(klass)) continue;
                try {
                    Configurable config = (Configurable)klass.newInstance();
                    config.configure(this);
                }
                catch (Exception e) {
                    System.err.println("Could not load class: " + klass);
                    e.printStackTrace();
                }
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not load package: " + packageName);
            e.printStackTrace();
        }
    }

    private static List<Class> getActionClasses(String packageName) throws ClassNotFoundException {
        String path;
        LinkedList<Class> classes = new LinkedList<Class>();
        File directory = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL resource = loader.getResource(path = packageName.replace('.', '/'));
        if (resource == null) {
            throw new ClassNotFoundException("No resource for " + path);
        }
        try {
            String filename = URLDecoder.decode(resource.getFile(), "UTF-8");
            if (File.separatorChar == '\\' && filename.startsWith("/")) {
                filename = filename.substring(1, filename.length());
            }
            directory = new File(filename);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Problem getting filename for " + resource.getFile());
        }
        if (directory.exists()) {
            String[] files = directory.list();
            for (int i = 0; i < files.length; ++i) {
                String classname;
                Class<?> teste;
                if (!files[i].endsWith(".class") || (teste = Class.forName(classname = packageName + '.' + files[i].replaceAll(".class", ""))).isInterface() || !teste.getSuperclass().equals(BaseAction.class) && !Action.class.isAssignableFrom(teste)) continue;
                classes.add(teste);
            }
        } else {
            throw new ClassNotFoundException(packageName + " does not appear to be a valid package");
        }
        return classes;
    }

    ApplicationManager setParent(ApplicationManager parent) {
        this.actions = parent.actions;
        this.components = parent.components;
        this.globalConsequences = parent.globalConsequences;
        this.globalFilters = parent.globalFilters;
        this.globalFiltersLast = parent.globalFiltersLast;
        this.innerActions = parent.innerActions;
        this.parent = parent;
        return this;
    }

    public ApplicationManager getParent() {
        return this.parent;
    }

    public void setConsequenceProvider(ConsequenceProvider consequenceProvider) {
        Controller.setConsequenceProvider(consequenceProvider);
    }

    public ConsequenceProvider getConsequenceProvider() {
        return Controller.getConsequenceProvider();
    }

    public void addList(DBListData list, ConnectionHandler connHandler) {
        ListManager.addList(list, connHandler);
    }

    public void addLocalizedLists(ConnectionHandler connHandler, String ... lists) {
        for (String list : lists) {
            this.addList(new DBListData(list, "id", "value", "locale", list, "id"), connHandler);
        }
    }

    public void addLists(ConnectionHandler connHandler, String ... lists) {
        for (String list : lists) {
            this.addList(new DBListData(list), connHandler);
        }
    }

    public void addList(ListData listData) {
        ListManager.addList(listData);
    }

    public void setDateMaskForEverything(String mask) {
        if (mask == null) {
            return;
        }
        FormatterManager.addFormatter("dateFormatter", new DateFormatter(mask));
        FormatterManager.setFixedDateFormatter(new DateFormatter(mask));
        LocaleManager.setDefaultDateMask(mask);
    }

    static {
        instance = null;
        viewDir = null;
        defaultAction = null;
        appContext = null;
        container = null;
        removeActionFromName = false;
    }

    public static enum Environment {
        TEST,
        DEV,
        INT,
        QA,
        PROD;

    }
}

