/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.mentawai.core.Context;
import org.mentawai.util.EnumerationToIterator;

public class ApplicationContext
implements Context,
Map<String, Object> {
    private ServletContext context;

    public ApplicationContext(ServletContext context) {
        this.context = context;
    }

    @Override
    public Object getAttribute(String name) {
        return this.context.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.context.setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.context.removeAttribute(name);
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("reset() is not supported for ApplicationContext!");
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.context.getAttribute(name) != null;
    }

    @Override
    public Iterator<String> keys() {
        return EnumerationToIterator.get(this.context.getAttributeNames());
    }

    @Override
    public void clear() {
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            this.removeAttribute(iter.next());
        }
    }

    @Override
    public boolean isEmpty() {
        int size = this.size();
        return size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.hasAttribute((String)key);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            String key = iter.next();
            Object v = this.getAttribute(key);
            if (v == null || !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            return this.getAttribute((String)key);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Set<String> keySet() {
        int size = this.size();
        if (size == 0) {
            return new HashSet<String>(0);
        }
        HashSet<String> set = new HashSet<String>(size);
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    @Override
    public Object put(String key, Object value) {
        this.setAttribute(key, value);
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof String) {
            String s = (String)key;
            Object obj = this.getAttribute(s);
            if (obj != null) {
                this.removeAttribute(s);
                return obj;
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            iter.next();
            ++size;
        }
        return size;
    }

    @Override
    public Collection<Object> values() {
        int size = this.size();
        if (size == 0) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> list = new ArrayList<Object>(size);
        Iterator<String> iter = this.keys();
        while (iter.hasNext()) {
            String key = iter.next();
            list.add(this.getAttribute(key));
        }
        return list;
    }
}

