/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.mentacontainer.Container;
import org.mentawai.ajax.AjaxConsequence;
import org.mentawai.ajax.AjaxRenderer;
import org.mentawai.core.Action;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Chain;
import org.mentawai.core.Consequence;
import org.mentawai.core.Filter;
import org.mentawai.core.Forward;
import org.mentawai.core.PojoAction;
import org.mentawai.core.Redirect;

public class ActionConfig {
    protected final Class<? extends Object> actionClass;
    private String name = null;
    private Map<String, Consequence> consequences = new HashMap<String, Consequence>();
    private Map<String, Map<String, Consequence>> innerConsequences = new HashMap<String, Map<String, Consequence>>();
    private List<Object[]> filters = new LinkedList<Object[]>();
    private List<Object[]> firstFilters = new LinkedList<Object[]>();
    private String innerAction = null;
    private String dirName = null;
    private Consequence catchAll = null;
    private boolean internal = false;

    public ActionConfig(Class<? extends Object> klass) {
        this.actionClass = klass;
        this.dirName = this.getDirFromClass(klass);
        this.name = ActionConfig.getName(klass);
    }

    public ActionConfig(String name, Class<? extends Object> klass) {
        if (name.indexOf(".") > 0) {
            StringTokenizer st = new StringTokenizer(name, ".");
            if (st.countTokens() != 2) {
                throw new IllegalArgumentException("Bad action name: " + name);
            }
            this.name = this.cutSlash(st.nextToken());
            this.innerAction = st.nextToken();
        } else {
            this.name = this.cutSlash(name);
        }
        this.actionClass = klass;
        this.dirName = this.getDirFromClass(klass);
    }

    public ActionConfig(String name, Class<? extends Object> klass, String innerAction) {
        this.actionClass = klass;
        this.name = this.cutSlash(name);
        this.innerAction = innerAction;
        this.dirName = this.getDirFromClass(klass);
    }

    public ActionConfig(Class<? extends Object> klass, String innerAction) {
        this.actionClass = klass;
        this.name = ActionConfig.getName(klass);
        this.innerAction = innerAction;
        this.dirName = this.getDirFromClass(klass);
    }

    protected String getDirFromClass(Class klass) {
        String classname = klass.getName();
        String[] s = classname.split("\\.");
        classname = s[s.length - 1];
        int index = (classname = classname.toLowerCase()).indexOf("action");
        if (index > 0) {
            classname = classname.substring(0, index);
        }
        return classname;
    }

    public ActionConfig addConsequence(String result, Consequence c) {
        this.consequences.put(result, c);
        return this;
    }

    public ActionConfig internalOnly() {
        this.internal = true;
        return this;
    }

    public boolean isInternalOnly() {
        return this.internal;
    }

    public ActionConfig on(String result, Consequence c) {
        return this.addConsequence(result, c);
    }

    public ActionConfig on(String result, String jsp) {
        return this.addConsequence(result, new Forward(jsp));
    }

    private String cutSlash(String name) {
        if (name.startsWith("/") && name.length() > 1) {
            return name.substring(1, name.length());
        }
        return name;
    }

    public ActionConfig addConsequence(String result, String innerAction, Consequence c) {
        if (this.innerAction != null) {
            throw new IllegalStateException("Calling addConsequence(result,innerAction,c) is illegal for inner action configs!");
        }
        Map<String, Consequence> map = this.innerConsequences.get(innerAction);
        if (map == null) {
            map = new HashMap<String, Consequence>();
            this.innerConsequences.put(innerAction, map);
        }
        map.put(result, c);
        return this;
    }

    public ActionConfig on(String result, String innerAction, Consequence c) {
        return this.addConsequence(result, innerAction, c);
    }

    public ActionConfig addFilter(Filter filter) {
        return this.addFilter(filter, (String)null);
    }

    public ActionConfig filter(Filter filter) {
        return this.addFilter(filter);
    }

    public Consequence getCatchAll() {
        return this.catchAll;
    }

    public ActionConfig catchAll(Consequence c) {
        this.catchAll = c;
        return this;
    }

    public ActionConfig addFilter(Filter filter, String innerAction) {
        Object[] array = new Object[]{innerAction, filter};
        this.filters.add(array);
        return this;
    }

    public ActionConfig filterFirst(List filters) {
        return this.addFilterFirst(filters);
    }

    public ActionConfig filterFirst(List filters, String innerAction) {
        return this.addFilterFirst(filters, innerAction);
    }

    public ActionConfig filterFirst(Filter filter) {
        return this.addFilterFirst(filter);
    }

    public ActionConfig filterFirst(Filter filter, String innerAction) {
        return this.addFilterFirst(filter, innerAction);
    }

    public ActionConfig addFilterFirst(List filters) {
        return this.addFilterFirst(filters, null);
    }

    public ActionConfig addFilterFirst(List filters, String innerAction) {
        for (Filter f : filters) {
            this.addFilterFirst(f, innerAction);
        }
        return this;
    }

    public ActionConfig addFilterFirst(Filter filter) {
        return this.addFilterFirst(filter, null);
    }

    public ActionConfig addFilterFirst(Filter filter, String innerAction) {
        Object[] array = new Object[]{innerAction, filter};
        this.firstFilters.add(array);
        return this;
    }

    private static String getName(Class<? extends Object> klass) {
        String[] tokens = klass.getName().split("\\.");
        String name = tokens[tokens.length - 1];
        if (ApplicationManager.removeActionFromName && name.endsWith("Action")) {
            int index = name.lastIndexOf("Action");
            name = name.substring(0, index);
        }
        return name;
    }

    public ActionConfig filter(Filter filter, String innerAction) {
        return this.addFilter(filter, innerAction);
    }

    public ActionConfig addFilter(List filters) {
        return this.addFilter(filters, null);
    }

    public ActionConfig filter(List filters) {
        return this.addFilter(filters);
    }

    public ActionConfig fwdOk(String page) {
        return this.addConsequence("success", new Forward(page));
    }

    public ActionConfig fwdError(String page) {
        return this.addConsequence("error", new Forward(page));
    }

    public ActionConfig ajaxOk(AjaxRenderer renderer) {
        return this.addConsequence("success", new AjaxConsequence(renderer));
    }

    public ActionConfig ajaxError(AjaxRenderer renderer) {
        return this.addConsequence("error", new AjaxConsequence(renderer));
    }

    public ActionConfig redirOk(String page) {
        return this.addConsequence("success", new Redirect(page));
    }

    public ActionConfig redirError(String page) {
        return this.addConsequence("error", new Redirect(page));
    }

    public ActionConfig redirOk() {
        return this.addConsequence("success", new Redirect());
    }

    public ActionConfig redirError() {
        return this.addConsequence("error", new Redirect());
    }

    public ActionConfig redirOk(String page, boolean flag) {
        return this.addConsequence("success", new Redirect(page, flag));
    }

    public ActionConfig redirError(String page, boolean flag) {
        return this.addConsequence("error", new Redirect(page, flag));
    }

    public ActionConfig chainOk(ActionConfig actionConfig) {
        return this.addConsequence("success", new Chain(actionConfig));
    }

    public ActionConfig chainError(ActionConfig actionConfig) {
        return this.addConsequence("error", new Chain(actionConfig));
    }

    public ActionConfig addFilter(List filters, String innerAction) {
        for (Filter f : filters) {
            this.addFilter(f, innerAction);
        }
        return this;
    }

    public ActionConfig addFilter(Filter filter, String ... args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                this.addFilter(filter, args[i]);
            }
        }
        return this;
    }

    public ActionConfig filter(Filter filter, String ... args) {
        return this.addFilter(filter, args);
    }

    public ActionConfig filter(List filters, String innerAction) {
        return this.addFilter(filters, innerAction);
    }

    public List<Filter> getFilters() {
        ArrayList<Filter> list = new ArrayList<Filter>(this.filters.size() + this.firstFilters.size());
        for (Object[] array : this.firstFilters) {
            list.add((Filter)array[1]);
        }
        for (Object[] array : this.filters) {
            list.add((Filter)array[1]);
        }
        return list;
    }

    public List<Filter> getFilters(String innerAction) {
        ArrayList<Filter> list = new ArrayList<Filter>(this.filters.size());
        for (Object[] array : this.filters) {
            if (array[0] != null && !array[0].equals(innerAction)) continue;
            list.add((Filter)array[1]);
        }
        return list;
    }

    public List<Filter> getFirstFilters(String innerAction) {
        ArrayList<Filter> list = new ArrayList<Filter>(this.firstFilters.size());
        for (Object[] array : this.firstFilters) {
            if (array[0] != null && !array[0].equals(innerAction)) continue;
            list.add((Filter)array[1]);
        }
        return list;
    }

    public String getName() {
        return this.name;
    }

    public String getInnerAction() {
        return this.innerAction;
    }

    void setInnerAction(String innerAction) {
        this.innerAction = innerAction;
    }

    public Consequence getConsequence(String result) {
        return this.consequences.get(result);
    }

    public Consequence getConsequence(String result, String innerAction) {
        Map<String, Consequence> map = this.innerConsequences.get(innerAction);
        if (map != null) {
            return map.get(result);
        }
        return null;
    }

    public Consequence getAutoConsequence(String result, String innerAction) {
        if (result == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append("/").append(this.dirName).append("/");
        if (innerAction != null) {
            sb.append(innerAction).append(".");
        }
        if (result.equals("success")) {
            sb.append("ok.jsp");
        } else {
            sb.append(result).append(".jsp");
        }
        Forward c = new Forward(sb.toString());
        if (innerAction != null) {
            this.addConsequence(result, innerAction, c);
        } else {
            this.addConsequence(result, c);
        }
        return c;
    }

    public Action getAction() {
        block11: {
            Container container = ApplicationManager.getContainer();
            if (Action.class.isAssignableFrom(this.actionClass)) {
                try {
                    Action a = (Action)container.construct(this.actionClass);
                    if (a != null) {
                        return a;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    return (Action)this.actionClass.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block11;
                }
            }
            try {
                Object pojo = null;
                try {
                    pojo = container.construct(this.actionClass);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (pojo == null) {
                    pojo = this.actionClass.newInstance();
                }
                PojoAction pojoAction = new PojoAction(pojo);
                return pojoAction;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Class<? extends Object> getActionClass() {
        return this.actionClass;
    }

    public String toString() {
        return this.name;
    }
}

