/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.core;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.mentawai.core.Input;
import org.mentawai.core.InputException;
import org.mentawai.util.InjectionUtils;
import org.mentawai.util.StringUtils;

public abstract class AbstractInput
implements Input {
    private static Boolean b;

    @Override
    public boolean getBoolean(String name) {
        String value = this.getString(name);
        if (value == null || value.trim().equals("")) {
            return false;
        }
        if ((value = value.trim()).equalsIgnoreCase("false")) {
            return false;
        }
        if (value.equalsIgnoreCase("true") || value.equals("on")) {
            return true;
        }
        int x = -1;
        try {
            x = Integer.parseInt(value);
            if (x == 0) {
                return false;
            }
            if (x == 1) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new InputException("Could not convert input to boolean: " + name + " (" + value + ")");
    }

    @Override
    public boolean getBooleanValue(String name) {
        return this.getBoolean(name);
    }

    @Override
    public boolean getBoolean(String name, boolean def) {
        String value = this.getString(name);
        if (value == null || value.trim().equals("")) {
            return def;
        }
        return this.getBoolean(name);
    }

    @Override
    public boolean getBooleanValue(String name, boolean def) {
        return this.getBoolean(name, def);
    }

    @Override
    public Date getDate(String name) {
        return this.getDate(name, null, 3);
    }

    @Override
    public Date getDate(String name, int style) {
        return this.getDate(name, null, style);
    }

    @Override
    public Date getDate(String name, String pattern) {
        return this.getDate(name, pattern, -1);
    }

    private Date getDate(String name, String pattern, int style) {
        Object obj = this.getValue(name);
        if (obj instanceof Date) {
            return (Date)obj;
        }
        String date = this.getString(name);
        if (StringUtils.isEmpty(date)) {
            return null;
        }
        date = date.trim();
        try {
            DateFormat df;
            if (pattern != null) {
                df = new SimpleDateFormat(pattern);
            } else if (style != -1) {
                df = DateFormat.getDateInstance(style, this.getLocale());
            } else {
                throw new IllegalStateException("Should never be here!");
            }
            return df.parse(date);
        }
        catch (ParseException e) {
            throw new InputException("Could not convert input to date: " + name + " (" + date + ")");
        }
    }

    protected abstract Locale getLocale();

    @Override
    public double getDouble(String name) {
        String value = this.getString(name);
        if (value == null || value.trim().equals("")) {
            return -1.0;
        }
        value = value.trim();
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            try {
                return StringUtils.parseCurrencyNumber(value, this.getLocale()).doubleValue();
            }
            catch (ParseException e1) {
                throw new InputException("Could not convert input to double: " + name + " (" + value + ")");
            }
        }
    }

    @Override
    public double getDoubleValue(String name) {
        return this.getDouble(name);
    }

    @Override
    public double getDouble(String name, double def) {
        String value = this.getString(name);
        if (value == null || value.trim().equals("")) {
            return def;
        }
        return this.getDouble(name);
    }

    @Override
    public double getDoubleValue(String name, double def) {
        return this.getDouble(name, def);
    }

    @Override
    public float getFloat(String name) {
        String value = this.getString(name);
        if (value == null || value.trim().equals("")) {
            return -1.0f;
        }
        value = value.trim();
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            try {
                return StringUtils.parseCurrencyNumber(value, this.getLocale()).floatValue();
            }
            catch (ParseException e1) {
                throw new InputException("Could not convert input to float: " + name + " (" + value + ")");
            }
        }
    }

    @Override
    public float getFloatValue(String name) {
        return this.getFloat(name);
    }

    @Override
    public float getFloat(String name, float def) {
        String value = this.getString(name);
        if (value == null || value.trim().equals("")) {
            return def;
        }
        return this.getFloat(name);
    }

    @Override
    public float getFloatValue(String name, float def) {
        return this.getFloat(name, def);
    }

    @Override
    public int getIntValue(String name) {
        return this.getInt(name);
    }

    @Override
    public int getInt(String name) {
        String value = this.getString(name);
        if (value == null || value.trim().equals("")) {
            return -1;
        }
        value = value.trim();
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new InputException("Could not convert input to number: " + name + " (" + value + ")");
        }
    }

    @Override
    public int getIntValue(String name, int def) {
        return this.getInt(name, def);
    }

    @Override
    public int getInt(String name, int def) {
        String value = this.getString(name);
        if (value == null || value.trim().equals("")) {
            return def;
        }
        return this.getInt(name);
    }

    @Override
    public int[] getInts(String name) {
        String[] values = this.getStrings(name);
        if (values == null || values.length == 0) {
            return null;
        }
        int[] ret = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                if (values[i] == null) {
                    throw new InputException("Cannot convert null value: " + name);
                }
                ret[i] = Integer.parseInt(values[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                throw new InputException("Could not convert input to numbers: " + name);
            }
        }
        return ret;
    }

    @Override
    public int[] getIntValues(String name) {
        return this.getInts(name);
    }

    @Override
    public long getLong(String name) {
        String value = this.getString(name);
        if (value == null || value.trim().equals("")) {
            return -1L;
        }
        value = value.trim();
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new InputException("Could not convert input to long: " + name + " (" + value + ")");
        }
    }

    @Override
    public long[] getLongs(String name) {
        String[] values = this.getStrings(name);
        if (values == null || values.length == 0) {
            return null;
        }
        long[] ret = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                if (values[i] == null) {
                    throw new InputException("Cannot convert null value: " + name);
                }
                ret[i] = Long.parseLong(values[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                throw new InputException("Could not convert input to numbers: " + name);
            }
        }
        return ret;
    }

    @Override
    public long getLongValue(String name) {
        return this.getLong(name);
    }

    @Override
    public long getLong(String name, long def) {
        String value = this.getString(name);
        if (value == null || value.trim().equals("")) {
            return def;
        }
        return this.getLong(name);
    }

    @Override
    public long getLongValue(String name, long def) {
        return this.getLong(name, def);
    }

    @Override
    public <E> E getObject(Class<? extends E> klass) {
        return this.getObject(this.getInstance(klass), null);
    }

    public <E> E getObject(Class<? extends E> klass, boolean convertBoolean) {
        return this.getObject(this.getInstance(klass), null, convertBoolean);
    }

    @Override
    public <E> E getObject(Class<? extends E> klass, String prefix) {
        return this.getObject(this.getInstance(klass), prefix, false);
    }

    public <E> E getObject(Class<? extends E> klass, String prefix, boolean convertBoolean) {
        return this.getObject(this.getInstance(klass), prefix, true, true, convertBoolean);
    }

    private <E> E getInstance(Class<? extends E> klass) {
        try {
            return klass.newInstance();
        }
        catch (Exception e) {
            throw new InputException(e);
        }
    }

    @Override
    public <E> E getObject(E bean) {
        return this.getObject(bean, null);
    }

    public <E> E getObject(E bean, boolean convertBoolean) {
        return this.getObject(bean, null, convertBoolean);
    }

    @Override
    public <E> E getObject(E bean, String prefix) {
        return this.getObject(bean, prefix, false);
    }

    public <E> E getObject(E bean, String prefix, boolean convertBoolean) {
        return this.getObject(bean, prefix, true, true, convertBoolean);
    }

    public <E> E getObject(E target, String prefix, boolean tryField, boolean tryToConvert, boolean convertBoolean) {
        try {
            InjectionUtils.getObject(target, this, this.getLocale(), tryField, prefix, tryToConvert, convertBoolean, false);
            return target;
        }
        catch (Exception e) {
            throw new InputException(e);
        }
    }

    @Override
    public <E extends Enum<E>> E getEnum(String key, Class<E> enumClass) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <E extends Enum<E>> Set<E> getEnums(String key, Class<E> enumClass) {
        String[] values = this.getStrings(key);
        if (values == null) {
            return null;
        }
        try {
            HashSet<E> result = new HashSet<E>(values.length);
            for (String v : values) {
                result.add(Enum.valueOf(enumClass, v));
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isB() {
        return b;
    }

    public static void main(String[] args) {
        if (AbstractInput.isB()) {
            System.out.println("AAAAA");
        } else {
            System.out.println("DDDDD");
        }
    }
}

