/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.mentawai.converter.ConversionException;
import org.mentawai.converter.LocaleConverter;
import org.mentawai.i18n.LocaleManager;

public class DateConverter
extends LocaleConverter {
    private static final int STYLE = 3;
    private int style = 3;
    private boolean useStyle = false;
    private SimpleDateFormat sdf = null;

    public DateConverter() {
    }

    public DateConverter(int style) {
        this.style = style;
        this.useStyle = true;
    }

    public DateConverter(SimpleDateFormat sdf) {
        this.sdf = sdf;
    }

    public DateConverter(String pattern) {
        this(new SimpleDateFormat(pattern));
    }

    @Override
    public Object convert(Object value, Locale loc) throws ConversionException {
        if (value instanceof String) {
            String s = ((String)value).trim();
            if (s.equals("")) {
                return null;
            }
            if (this.sdf != null) {
                try {
                    return this.sdf.parse(s);
                }
                catch (ParseException e) {
                    throw new ConversionException(e);
                }
            }
            if (!this.useStyle && LocaleManager.getDateMask(loc) != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(LocaleManager.getDateMask(loc));
                try {
                    return sdf.parse(s);
                }
                catch (ParseException e) {
                    return new ConversionException(e);
                }
            }
            DateFormat df = DateFormat.getDateInstance(this.style, loc);
            df.setLenient(false);
            try {
                return df.parse(s);
            }
            catch (ParseException e) {
                throw new ConversionException(e);
            }
        }
        throw new ConversionException("DateConverter can only parse strings: " + value.toString());
    }
}

