/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.converter;

import org.mentawai.converter.BasicConverter;
import org.mentawai.converter.ConversionException;

public class BooleanConverter
extends BasicConverter {
    private final boolean notPresentIsFalse;

    public BooleanConverter() {
        this(false);
    }

    public BooleanConverter(boolean notPresentIsFalse) {
        this.notPresentIsFalse = notPresentIsFalse;
    }

    @Override
    protected boolean allowNull() {
        return true;
    }

    @Override
    public Object convert(Object value) throws ConversionException {
        if (value == null && this.notPresentIsFalse) {
            return Boolean.FALSE;
        }
        if (value == null) {
            throw new ConversionException("Cannot convert null value!");
        }
        String s = value.toString();
        if (s.equalsIgnoreCase("true") || s.equals("on")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        int x = -1;
        try {
            x = Integer.parseInt(s);
            if (x == 0) {
                return Boolean.FALSE;
            }
            if (x == 1) {
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            throw new ConversionException("Cannot convert " + s + " to a boolean!");
        }
        throw new ConversionException("Cannot convert the number " + x + " to a boolean!");
    }
}

