/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.coc;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.mentawai.coc.ConsequenceProvider;
import org.mentawai.coc.ForwardConsequenceProvider;
import org.mentawai.core.Action;
import org.mentawai.core.ActionConfig;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Consequence;
import org.mentawai.log.Debug;

public class CoCActionConfig
extends ActionConfig {
    private static final String NAME = "CocActionConfig";
    private static final Map<String, Class<Action>> actionClassCache = new HashMap<String, Class<Action>>();
    private static final String webinfClasses = ApplicationManager.getRealPath() + File.separator + "WEB-INF" + File.separator + "classes" + File.separator;
    private static ConsequenceProvider consequenceProvider;

    private static void readDir(File dir) {
        File[] files;
        for (File f : files = dir.listFiles()) {
            if (f.isDirectory()) {
                CoCActionConfig.readDir(f);
                continue;
            }
            String filename = f.getAbsolutePath();
            if (!filename.endsWith("Action.class")) continue;
            String classname = filename.substring(webinfClasses.length(), filename.length() - 6);
            classname = classname.replace('/', '.');
            classname = classname.replace('\\', '.');
            Class<?> klass = null;
            try {
                klass = Class.forName(classname);
                if (Action.class.isAssignableFrom(klass)) {
                    actionClassCache.put(klass.getSimpleName(), klass);
                    continue;
                }
                Debug.log(NAME, "Class", klass.getName(), "end's with 'Action' posfix, but is not a implemenof", Action.class.getName(), "interface.");
            }
            catch (ClassNotFoundException e) {
                Debug.log(NAME, "Could not load class", classname, "exception =", e);
            }
        }
    }

    public static void loadAllActions() {
        File dir = new File(webinfClasses);
        if (dir.isDirectory()) {
            CoCActionConfig.readDir(dir);
        }
    }

    public CoCActionConfig(String name) {
        super(name, actionClassCache.get(name));
    }

    @Override
    public Consequence getConsequence(String result) {
        Consequence consequence = super.getConsequence(result);
        if (consequence == null) {
            consequence = consequenceProvider.getConsequence(this.getName(), this.getActionClass(), result, null);
            this.addConsequence(result, consequence);
        }
        return consequence;
    }

    @Override
    public Consequence getConsequence(String result, String innerAction) {
        Consequence consequence = super.getConsequence(result, innerAction);
        if (consequence == null) {
            consequence = consequenceProvider.getConsequence(this.getName(), this.getActionClass(), result, innerAction);
            this.addConsequence(result, innerAction, consequence);
        }
        return consequence;
    }

    public static void setConsequenceProvider(ConsequenceProvider consequenceProvider) {
        CoCActionConfig.consequenceProvider = consequenceProvider;
    }

    static {
        CoCActionConfig.loadAllActions();
        consequenceProvider = new ForwardConsequenceProvider();
    }
}

