/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mentawai.cache.AbstractCache;

public class TimeoutCache
extends AbstractCache
implements Runnable {
    private final long timeout;
    private Thread thread = null;
    private volatile boolean bThread = true;

    public TimeoutCache(String name, int capacity, long timeout) {
        super(name, capacity);
        this.timeout = timeout;
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.bThread) {
            long now = System.currentTimeMillis();
            TimeoutCache timeoutCache = this;
            synchronized (timeoutCache) {
                Iterator iter = this.map.values().iterator();
                while (iter.hasNext()) {
                    Entry entry = (Entry)iter.next();
                    if (!entry.isExpired(now)) continue;
                    iter.remove();
                }
            }
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void close() {
        this.bThread = false;
        this.thread.interrupt();
        this.thread = null;
    }

    @Override
    protected Map<Object, Object> createMap(int initialCapacity, float load) {
        return new HashMap<Object, Object>(initialCapacity, load);
    }

    @Override
    public synchronized Object remove(Object key) {
        Entry entry = (Entry)super.remove(key);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    @Override
    public synchronized Object get(Object key) {
        Entry entry = (Entry)super.get(key);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (this.map.size() == this.capacity && !this.map.containsKey(key)) {
            return null;
        }
        Entry entry = this.map.put(key, new Entry(value));
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    private class Entry {
        long ts = System.currentTimeMillis();
        Object value = null;

        public Entry(Object value) {
            this.value = value;
        }

        public boolean isExpired(long now) {
            return now - this.ts >= TimeoutCache.this.timeout;
        }
    }
}

