/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.cache;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.util.Util;
import org.mentawai.cache.Cache;

public class SynchronizedCache
implements Cache,
MessageListener {
    public static final String JGROUPS_PROTOCOL_STACK = "UDP:PING:FD(timeout=5000):STABLE:VERIFY_SUSPECT(timeout=1500):MERGE2:NAKACK:UNICAST(timeout=5000):FRAG:FLUSH:GMS:VIEW_ENFORCER:QUEUE";
    private Cache cache;
    private JChannel channel;
    private PullPushAdapter adapter;
    private String groupname;

    public SynchronizedCache(String name, String groupname, int capacity, Class cacheImpl, String jgroups_protocol_stack) {
        try {
            Constructor c = cacheImpl.getConstructor(String.class, Integer.TYPE);
            this.cache = (Cache)c.newInstance(name, new Integer(capacity));
            this.initChannel(groupname, jgroups_protocol_stack);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating synchronized cache!", e);
        }
    }

    public SynchronizedCache(String name, String groupname, int capacity, Class cacheImpl) {
        this(name, groupname, capacity, cacheImpl, JGROUPS_PROTOCOL_STACK);
    }

    public SynchronizedCache(String name, String groupname, int capacity, float load, Class cacheImpl, String jgroups_protocol_stack) {
        try {
            Constructor c = cacheImpl.getConstructor(String.class, Integer.TYPE, Float.TYPE);
            this.cache = (Cache)c.newInstance(name, new Integer(capacity), new Float(load));
            this.initChannel(groupname, jgroups_protocol_stack);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating synchronized cache!", e);
        }
    }

    public SynchronizedCache(String name, String groupname, int capacity, float load, Class cacheImpl) {
        this(name, groupname, capacity, load, cacheImpl, JGROUPS_PROTOCOL_STACK);
    }

    private void initChannel(String groupname, String stack) throws Exception {
        this.groupname = groupname;
        this.channel = new JChannel(stack);
        this.channel.connect(groupname);
        this.adapter = new PullPushAdapter((Transport)this.channel, (MessageListener)this);
    }

    @Override
    public Object get(Object key) {
        return this.cache.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        Object obj = this.cache.put(key, value);
        if (obj != null) {
            try {
                this.channel.send(null, null, (Serializable)key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    @Override
    public Object remove(Object key) {
        return this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("SynchronizedCache: GroupName=").append(this.groupname).append("\n");
        sb.append(this.cache.toString());
        return sb.toString();
    }

    public void receive(Message msg) {
        try {
            Object key = Util.objectFromByteBuffer((byte[])msg.getBuffer());
            this.cache.remove(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setState(byte[] state) {
    }

    public byte[] getState() {
        return null;
    }
}

