/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.cache;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.util.Util;
import org.mentawai.cache.Cache;
import org.mentawai.cache.DistributedCacheMessage;
import org.mentawai.cache.LRUCache;

public class DistributedCache
implements Cache,
MessageListener {
    public static final String JGROUPS_PROTOCOL_STACK = "UDP:PING:FD(timeout=5000):STABLE:VERIFY_SUSPECT(timeout=1500):MERGE2:NAKACK:UNICAST(timeout=5000):FRAG:FLUSH:GMS:VIEW_ENFORCER:STATE_TRANSFER:QUEUE";
    private Cache cache;
    private JChannel channel;
    private PullPushAdapter adapter;
    private String groupname;

    public DistributedCache(String name, String groupname, int capacity, Class cacheImpl, String jgroups_protocol_stack) {
        try {
            Constructor c = cacheImpl.getConstructor(String.class, Integer.TYPE);
            this.cache = (Cache)c.newInstance(name, new Integer(capacity));
            this.initChannel(groupname, jgroups_protocol_stack);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating synchronized cache!", e);
        }
    }

    public DistributedCache(String name, String groupname, int capacity) {
        this(name, groupname, capacity, LRUCache.class);
    }

    public DistributedCache(String name, String groupname, int capacity, Class cacheImpl) {
        this(name, groupname, capacity, cacheImpl, JGROUPS_PROTOCOL_STACK);
    }

    public DistributedCache(String name, String groupname, int capacity, float load, Class cacheImpl, String jgroups_protocol_stack) {
        try {
            Constructor c = cacheImpl.getConstructor(String.class, Integer.TYPE, Float.TYPE);
            this.cache = (Cache)c.newInstance(name, new Integer(capacity), new Float(load));
            this.initChannel(groupname, jgroups_protocol_stack);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating synchronized cache!", e);
        }
    }

    public DistributedCache(String name, String groupname, int capacity, float load, Class cacheImpl) {
        this(name, groupname, capacity, load, cacheImpl, JGROUPS_PROTOCOL_STACK);
    }

    private void initChannel(String groupname, String stack) throws Exception {
        this.groupname = groupname;
        this.channel = new JChannel(stack);
        this.channel.setOpt(4, (Object)Boolean.TRUE);
        this.channel.connect(groupname);
        this.adapter = new PullPushAdapter((Transport)this.channel, (MessageListener)this);
        this.channel.getState(null, 0L);
    }

    @Override
    public synchronized Object get(Object key) {
        return this.cache.get(key);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.put(key, value, true);
    }

    protected synchronized Object put(Object key, Object value, boolean send) {
        Object obj = this.cache.put(key, value);
        if (send) {
            try {
                DistributedCacheMessage msg = new DistributedCacheMessage(1, (Serializable)key, (Serializable)value);
                this.channel.send(null, null, (Serializable)msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    @Override
    public synchronized Object remove(Object key) {
        return this.remove(key, true);
    }

    protected synchronized Object remove(Object key, boolean send) {
        Object obj = this.cache.remove(key);
        if (send) {
            try {
                DistributedCacheMessage msg = new DistributedCacheMessage(2, (Serializable)key);
                this.channel.send(null, null, (Serializable)msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    @Override
    public synchronized void clear() {
        this.clear(true);
    }

    protected synchronized void clear(boolean send) {
        this.cache.clear();
        if (send) {
            try {
                DistributedCacheMessage msg = new DistributedCacheMessage(3);
                this.channel.send(null, null, (Serializable)msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("ReplicatedCache: GroupName=").append(this.groupname).append("\n");
        sb.append(this.cache.toString());
        return sb.toString();
    }

    public synchronized void receive(Message msg) {
        try {
            Object obj = Util.objectFromByteBuffer((byte[])msg.getBuffer());
            if (obj instanceof DistributedCacheMessage) {
                DistributedCacheMessage message = (DistributedCacheMessage)obj;
                if (message.getType() == 1) {
                    this.put(message.getKey(), message.getValue(), false);
                } else if (message.getType() == 2) {
                    this.remove(message.getKey(), false);
                } else if (message.getType() == 3) {
                    this.clear(false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void setState(byte[] state) {
        try {
            this.cache = (Cache)Util.objectFromByteBuffer((byte[])state);
        }
        catch (Exception e) {
            System.err.println("Error setting jgroups state!");
            e.printStackTrace();
        }
    }

    public synchronized byte[] getState() {
        try {
            return Util.objectToByteBuffer((Object)this.cache);
        }
        catch (Exception e) {
            System.err.println("Error getting jgroups state!");
            e.printStackTrace();
            return null;
        }
    }
}

